/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nl.lexemmens.podman.authentication.AuthConfig;
import nl.lexemmens.podman.authentication.AuthConfigFactory;
import nl.lexemmens.podman.service.PodmanExecutorService;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.json.JSONObject;
import org.json.JSONTokener;

public class AuthenticationService {
    private static final String AUTHS_KEY_PODMAN_CFG = "auths";
    private static final String XDG_RUNTIME_DIR = "XDG_RUNTIME_DIR";
    private static final String REGISTRY_AUTH_FILE = "REGISTRY_AUTH_FILE";
    private static final String AUTH_JSON_SUB_PATH = "containers/auth.json";
    private static final String DOCKER_CONFIG_FILE = ".docker/config.json";
    private final Log log;
    private final PodmanExecutorService podmanExecutorService;
    private final AuthConfigFactory authConfigFactory;

    public AuthenticationService(Log log, PodmanExecutorService podmanExecutorService, Settings mavenSetings, SettingsDecrypter settingsDecrypter) {
        this.podmanExecutorService = podmanExecutorService;
        this.log = log;
        this.authConfigFactory = new AuthConfigFactory(mavenSetings, settingsDecrypter);
    }

    public void authenticate(String[] registries) throws MojoExecutionException {
        this.log.info((CharSequence)"Checking authentication status...");
        if (registries == null || registries.length == 0) {
            String msg = "No registries have been configured but authentication is not skipped. If you want to skip authentication, run again with 'podman.skip.auth' set to true";
            this.log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        List<Path> registryAuthFiles = this.getRegistryAuthFiles();
        if (registryAuthFiles.isEmpty()) {
            this.log.info((CharSequence)"Authentication file not (yet) present. Authenticating...");
            this.authenticateRegistries(registries);
        } else {
            this.log.debug((CharSequence)"Checking unauthenticated registries...");
            this.authenticateUnauthenticatedRegistries(registries, registryAuthFiles);
        }
        this.log.debug((CharSequence)"Authentication status: OK!");
    }

    private List<Path> getRegistryAuthFiles() {
        Path dockerConfigFile;
        Path xdgRuntimeDir;
        Path defaultAuthFile;
        Path customRegistryAuthFile;
        ArrayList<Path> registryAuthFiles = new ArrayList<Path>();
        if (System.getenv().containsKey(REGISTRY_AUTH_FILE) && Files.exists(customRegistryAuthFile = Paths.get(System.getenv(REGISTRY_AUTH_FILE), new String[0]), new LinkOption[0])) {
            this.log.debug((CharSequence)("Found custom registry authentication file at: " + customRegistryAuthFile));
            registryAuthFiles.add(customRegistryAuthFile);
        }
        if (System.getenv().containsKey(XDG_RUNTIME_DIR) && Files.exists(defaultAuthFile = (xdgRuntimeDir = Paths.get(System.getenv(XDG_RUNTIME_DIR), new String[0])).resolve(AUTH_JSON_SUB_PATH), new LinkOption[0])) {
            this.log.debug((CharSequence)("Found default registry authentication file at: " + defaultAuthFile));
            registryAuthFiles.add(defaultAuthFile);
        }
        if (Files.exists(dockerConfigFile = Paths.get(System.getProperty("user.home"), new String[0]).resolve(DOCKER_CONFIG_FILE), new LinkOption[0])) {
            this.log.debug((CharSequence)("Found Docker registry authentication file at: " + dockerConfigFile));
            registryAuthFiles.add(dockerConfigFile);
        }
        if (registryAuthFiles.isEmpty()) {
            this.log.warn((CharSequence)"Could not locate suitable credentials for Podman. If this error persists, try running with <skipAuth>true</skipAuth>.");
        }
        return registryAuthFiles;
    }

    private void authenticateUnauthenticatedRegistries(String[] registries, List<Path> registryAuthFilePaths) throws MojoExecutionException {
        Set<String> authenticatedRegistries = this.getAuthenticatedRegistries(registryAuthFilePaths);
        ArrayList<String> unauthenticatedRegistries = new ArrayList<String>();
        for (String registry : registries) {
            if (authenticatedRegistries.contains(registry)) continue;
            unauthenticatedRegistries.add(registry);
        }
        this.authenticateRegistries(unauthenticatedRegistries.toArray(new String[0]));
    }

    private void authenticateRegistries(String[] registries) throws MojoExecutionException {
        for (String registry : registries) {
            Optional<AuthConfig> authConfigOptional = this.authConfigFactory.getAuthConfigForRegistry(registry);
            if (!authConfigOptional.isPresent()) {
                String msg = "Credentials are missing for registry " + registry + ". Add credentials by specifying the server in the Maven's settings.xml (usually located in ~/.m2/)";
                this.log.error((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
            AuthConfig authConfig = authConfigOptional.get();
            this.authenticate(authConfig.getRegistry(), authConfig.getUsername(), authConfig.getPassword());
        }
    }

    private void authenticate(String registry, String username, String password) throws MojoExecutionException {
        this.log.debug((CharSequence)("Authenticating " + registry));
        this.podmanExecutorService.login(registry, username, password);
    }

    private Set<String> getAuthenticatedRegistries(List<Path> registryAuthFilePaths) throws MojoExecutionException {
        HashSet<String> authenticatedRegistries = new HashSet<String>();
        for (Path registryAuthFilePath : registryAuthFilePaths) {
            JSONObject podmanConfigJson = AuthenticationService.readPodmanConfig(registryAuthFilePath);
            if (podmanConfigJson == null || !podmanConfigJson.has(AUTHS_KEY_PODMAN_CFG)) {
                this.log.debug((CharSequence)"No authenticated registries were found.");
                continue;
            }
            Object auths = podmanConfigJson.get(AUTHS_KEY_PODMAN_CFG);
            if (auths instanceof JSONObject) {
                authenticatedRegistries.addAll(((JSONObject)auths).keySet());
                continue;
            }
            this.log.warn((CharSequence)"Failed to read authenticated registries. Maven might re-authenticate...");
        }
        this.log.debug((CharSequence)("Found authentication details for the following registries: " + authenticatedRegistries));
        return authenticatedRegistries;
    }

    private static JSONObject readPodmanConfig(Path registryAuthFilePath) throws MojoExecutionException {
        Reader reader = AuthenticationService.getFileReader(registryAuthFilePath);
        return reader != null ? new JSONObject(new JSONTokener(reader)) : null;
    }

    private static Reader getFileReader(Path registryAuthFilePath) throws MojoExecutionException {
        File file = registryAuthFilePath.toFile();
        if (file.exists() && file.length() != 0L) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Cannot find " + file, (Exception)e);
            }
        }
        return null;
    }
}

