/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.File;
import nl.lexemmens.podman.command.buildah.BuildahUnshareCommand;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class BuildahExecutorService {
    private final Log log;
    private final CommandExecutorDelegate delegate;
    private final File podmanRoot;

    public BuildahExecutorService(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
        this.log = log;
        this.delegate = delegate;
        this.podmanRoot = podmanConfig.getRoot();
    }

    public void cleanupLocalContainerStorage() throws MojoExecutionException {
        if (this.podmanRoot == null) {
            this.log.info((CharSequence)"Podman root storage location is set to its defaults. Not cleaning up this storage location.");
            return;
        }
        new BuildahUnshareCommand.Builder(this.log, this.delegate).removeDirectory(this.podmanRoot.getAbsolutePath()).build().execute();
    }
}

