/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import nl.lexemmens.podman.command.podman.PodmanBuildCommand;
import nl.lexemmens.podman.command.podman.PodmanLoginCommand;
import nl.lexemmens.podman.command.podman.PodmanPushCommand;
import nl.lexemmens.podman.command.podman.PodmanRmiCommand;
import nl.lexemmens.podman.command.podman.PodmanSaveCommand;
import nl.lexemmens.podman.command.podman.PodmanTagCommand;
import nl.lexemmens.podman.command.podman.PodmanVersionCommand;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.enumeration.PullPolicy;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PodmanExecutorService {
    private final Log log;
    private final CommandExecutorDelegate delegate;
    private final PodmanConfiguration podmanConfig;

    public PodmanExecutorService(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
        this.log = log;
        this.delegate = delegate;
        this.podmanConfig = podmanConfig;
    }

    public List<String> build(SingleImageConfiguration image) throws MojoExecutionException {
        Optional<String> targetStage;
        Optional<String> platform;
        Optional<PullPolicy> pullPolicyOptional;
        PodmanBuildCommand.Builder builder = new PodmanBuildCommand.Builder(this.log, this.podmanConfig, this.delegate).setFormat(image.getBuild().getFormat().getValue()).setContainerFile(image.getBuild().getTargetContainerFile()).setNoCache(image.getBuild().isNoCache());
        if (Boolean.TRUE == image.getBuild().getSquash()) {
            builder = builder.setSquash();
        }
        if (Boolean.TRUE == image.getBuild().getSquashAll()) {
            builder = builder.setSquashAll();
        }
        if (image.getBuild().getLayers() != null) {
            builder = builder.setLayers(image.getBuild().getLayers());
        }
        if ((pullPolicyOptional = image.getBuild().getPullPolicy()).isPresent()) {
            builder = builder.setPullPolicy(pullPolicyOptional.get().getValue());
        }
        if ((platform = image.getBuild().getPlatform()).isPresent()) {
            builder = builder.setPlatform(platform.get());
        }
        if ((targetStage = image.getBuild().getTargetStage()).isPresent()) {
            builder.setTargetStage(targetStage.get());
        }
        builder.addBuildArgs(image.getBuild().getArgs());
        Optional<String> contextDir = image.getBuild().getContextDir();
        if (contextDir.isPresent()) {
            builder = builder.setContextDir(contextDir.get());
        }
        builder.addUlimitsArgs(image.getBuild().getUlimits());
        return builder.build().execute();
    }

    public void tag(String imageHash, String fullImageName) throws MojoExecutionException {
        new PodmanTagCommand.Builder(this.log, this.podmanConfig, this.delegate).setImageHash(imageHash).setFullImageName(fullImageName).build().execute();
    }

    public void save(String archiveName, String fullImageName) throws MojoExecutionException {
        new PodmanSaveCommand.Builder(this.log, this.podmanConfig, this.delegate).setArchiveName(archiveName).setFullImageName(fullImageName).build().execute();
    }

    public void push(String fullImageName) throws MojoExecutionException {
        new PodmanPushCommand.Builder(this.log, this.podmanConfig, this.delegate).setFullImageName(fullImageName).build().execute();
    }

    public void login(String registry, String username, String password) throws MojoExecutionException {
        try {
            new PodmanLoginCommand.Builder(this.log, this.podmanConfig, this.delegate).setRegistry(registry).setUsername(username).setPassword(password).build().execute();
        }
        catch (MojoExecutionException e) {
            String message = e.getMessage().replaceAll(String.format("-p[,=]+%s", Pattern.quote(password)), "-p=**********");
            this.log.error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    public void version() throws MojoExecutionException {
        new PodmanVersionCommand.Builder(this.log, this.podmanConfig, this.delegate).build().execute();
    }

    public void removeLocalImage(String fullImageName) throws MojoExecutionException {
        new PodmanRmiCommand.Builder(this.log, this.podmanConfig, this.delegate).setFullImageName(fullImageName).build().execute();
    }
}

