/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.lexemmens.podman.command.Command;
import nl.lexemmens.podman.command.chcon.ChConCommand;
import nl.lexemmens.podman.command.podman.PodmanSystemCommand;
import nl.lexemmens.podman.command.sestatus.SeStatusCommand;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class SecurityContextService {
    private static final String TARGET_SECURITY_CONTEXT_TYPE = "data_home_t";
    private static final Pattern SELINUX_STATUS_REGEX = Pattern.compile("(SELinux status:\\s*)(enabled|disabled)");
    private static final Pattern GRAPH_ROOT_PATTERN = Pattern.compile("(graphRoot: )([a-zA-Z\\/\\.]+)");
    private static final String UNKNOWN = "unknown";
    private final Log log;
    private final PodmanConfiguration podmanCfg;
    private final CommandExecutorDelegate delegate;

    public SecurityContextService(Log log, PodmanConfiguration podmanConfiguration, CommandExecutorDelegate delegate) {
        this.podmanCfg = podmanConfiguration;
        this.log = log;
        this.delegate = delegate;
    }

    public void setSecurityContext() throws MojoExecutionException {
        this.log.debug((CharSequence)"Checking SELinux status...");
        boolean seLinuxEnabled = this.isSELinuxEnabled();
        if (seLinuxEnabled) {
            this.log.debug((CharSequence)"SELinux is enabled");
            this.doSetSecurityContext();
        } else {
            this.log.debug((CharSequence)"Not setting security context because SELinux is disabled.");
        }
    }

    private boolean isSELinuxEnabled() throws MojoExecutionException {
        Command seStatusCommand = new SeStatusCommand.Builder(this.log, this.delegate).build();
        try {
            Optional<String> seLinuxStatus = seStatusCommand.execute().stream().filter(line -> line.contains("SELinux status")).map(this::extractSeLinuxStatus).findFirst();
            return seLinuxStatus.map(seLinuxStatusString -> seLinuxStatusString.equals("enabled")).orElse(false);
        }
        catch (MojoExecutionException mee) {
            this.log.debug((CharSequence)"SELinux is not installed or not available", (Throwable)mee);
            return false;
        }
    }

    private String extractSeLinuxStatus(String line) {
        Matcher seLinuxStatusMatcher = SELINUX_STATUS_REGEX.matcher(line);
        if (seLinuxStatusMatcher.matches()) {
            return seLinuxStatusMatcher.group(2);
        }
        this.log.warn((CharSequence)"Unable to determine if SELinux is enabled! Continuing without setting proper security context.");
        return UNKNOWN;
    }

    private void doSetSecurityContext() throws MojoExecutionException {
        if (this.podmanCfg.getRoot() == null) {
            this.log.debug((CharSequence)"Using Podman default storage location. Assuming security context is set correctly for this location. Refer to the documentation of this plugin if you run into any issues.");
        } else {
            this.log.debug((CharSequence)("Using custom root with SELinux enabled. Setting security context to data_home_t for " + this.podmanCfg.getRoot()));
            try {
                Path path = this.podmanCfg.getRoot().toPath().normalize();
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to set security context on Podman's (custom) root location: " + this.podmanCfg.getRoot().getAbsolutePath(), (Exception)e);
            }
            List graphRootCmdOutput = new PodmanSystemCommand.Builder(this.log, this.podmanCfg, this.delegate).info().build().execute().stream().filter(output -> output.matches("(graphRoot: )([a-zA-Z\\/\\.]+)")).collect(Collectors.toList());
            if (graphRootCmdOutput.size() == 1) {
                String graphRoot = (String)graphRootCmdOutput.get(0);
                Matcher graphRootMatcher = GRAPH_ROOT_PATTERN.matcher(graphRoot);
                if (graphRootMatcher.matches()) {
                    String graphRootLocation = graphRootMatcher.group(2);
                    this.log.info((CharSequence)("Determined graphRoot location to be: " + graphRootLocation + ". Executing chcon using this directory as reference..."));
                    this.executeChConCommand(graphRootLocation);
                } else {
                    this.log.warn((CharSequence)("Failed to determine Podman's storage location from output " + graphRoot));
                }
            } else {
                this.log.warn((CharSequence)"Failed to determine Podman's storage location. If SELinux is enabled, this may cause unexpected behaviour.");
            }
        }
    }

    private void executeChConCommand(String referenceStorageLocation) throws MojoExecutionException {
        Command chconCommand = new ChConCommand.Builder(this.log, this.delegate).withRecursiveOption().withReferenceDirectory(referenceStorageLocation, this.podmanCfg.getRoot().getAbsolutePath()).build();
        chconCommand.execute();
    }
}

