/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.util.ArrayList;
import java.util.List;
import nl.lexemmens.podman.config.image.batch.BatchImageConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.helper.ImageNameHelper;
import nl.lexemmens.podman.service.ServiceHub;
import nl.lexemmens.podman.service.ServiceHubFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenFileFilter;

public abstract class AbstractPodmanMojo
extends AbstractMojo {
    protected static final String PODMAN_DIRECTORY = "podman";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="podman.registries")
    protected String[] registries;
    @Parameter(property="podman.push.registry")
    protected String pushRegistry;
    @Parameter
    protected List<SingleImageConfiguration> images;
    @Parameter
    protected BatchImageConfiguration batch;
    @Parameter
    protected PodmanConfiguration podman;
    @Parameter(property="podman.skip.auth", defaultValue="false")
    protected boolean skipAuth;
    @Parameter(property="podman.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="podman.fail.on.missing.containerfile", defaultValue="true")
    protected boolean failOnMissingContainerfile;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Component
    private ServiceHubFactory serviceHubFactory;
    @Component
    private SettingsDecrypter settingsDecrypter;
    protected final List<SingleImageConfiguration> resolvedImages;
    private final boolean requireImageConfiguration;

    protected AbstractPodmanMojo() {
        this.requireImageConfiguration = true;
        this.resolvedImages = new ArrayList<SingleImageConfiguration>();
    }

    protected AbstractPodmanMojo(boolean requireImageConfiguration) {
        this.requireImageConfiguration = requireImageConfiguration;
        this.resolvedImages = new ArrayList<SingleImageConfiguration>();
    }

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Podman actions are skipped.");
            return;
        }
        this.initConfigurations();
        ServiceHub hub = this.serviceHubFactory.createServiceHub(this.getLog(), this.project, this.mavenFileFilter, this.podman, this.settings, this.settingsDecrypter);
        this.printPodmanVersion(hub);
        this.executeInternal(hub);
    }

    private void printPodmanVersion(ServiceHub hub) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            hub.getPodmanExecutorService().version();
        }
    }

    private void initConfigurations() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Initializing configurations.");
        if (this.podman == null) {
            this.getLog().debug((CharSequence)"Using default Podman configuration.");
            this.podman = new PodmanConfiguration();
        }
        this.podman.initAndValidate(this.project, this.getLog());
        if (this.requireImageConfiguration) {
            this.resolveImages();
            if (this.resolvedImages.isEmpty()) {
                throw new MojoExecutionException("Cannot invoke plugin while there is no image configuration present!");
            }
            ImageNameHelper imageNameHelper = new ImageNameHelper(this.project);
            for (SingleImageConfiguration image : this.resolvedImages) {
                image.initAndValidate(this.project, this.getLog(), this.failOnMissingContainerfile);
                imageNameHelper.adaptReplacemeents(image);
                imageNameHelper.formatImageName(image);
            }
        } else {
            this.getLog().debug((CharSequence)"Validating image configuration is skipped.");
        }
    }

    private void resolveImages() throws MojoExecutionException {
        if (this.batch != null) {
            this.getLog().warn((CharSequence)"NOTE: Batch mode enabled.");
            this.batch.initAndValidate(this.getLog(), this.project);
            this.resolvedImages.addAll(this.batch.resolve(this.getLog()));
        }
        if (this.images != null && !this.images.isEmpty()) {
            this.resolvedImages.addAll(this.images);
        }
    }

    protected void checkAuthentication(ServiceHub hub) throws MojoExecutionException {
        if (this.skipAuth) {
            this.getLog().info((CharSequence)"Registry authentication is skipped.");
        } else {
            hub.getAuthenticationService().authenticate(this.registries);
        }
    }

    protected String getFullImageNameWithPushRegistry(String imageNameWithTag) {
        String fullImageName = imageNameWithTag;
        if (this.pushRegistry != null) {
            fullImageName = String.format("%s/%s", this.pushRegistry, imageNameWithTag);
        }
        return fullImageName;
    }

    public abstract void executeInternal(ServiceHub var1) throws MojoExecutionException;
}

