/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import nl.lexemmens.podman.AbstractPodmanMojo;
import nl.lexemmens.podman.service.ServiceHub;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", defaultPhase=LifecyclePhase.PRE_CLEAN)
public class CleanMojo
extends AbstractPodmanMojo {
    @Parameter(property="podman.skip.clean", defaultValue="false")
    boolean skipClean;

    public CleanMojo() {
        super(false);
    }

    @Override
    public void executeInternal(ServiceHub hub) throws MojoExecutionException {
        if (this.skipClean) {
            this.getLog().info((CharSequence)"Cleaning local storage is skipped.");
            return;
        }
        if (this.podman.getRoot() == null) {
            this.getLog().info((CharSequence)"Not cleaning up local storage as default storage location is being used.");
        } else {
            this.getLog().info((CharSequence)("Cleaning up " + this.podman.getRoot().getAbsolutePath() + "..."));
            hub.getBuildahExecutorService().cleanupLocalContainerStorage();
        }
    }
}

