/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.authentication;

import java.util.Optional;
import nl.lexemmens.podman.authentication.AuthConfig;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

public class AuthConfigFactory {
    private Settings mavenSettings;
    private final SettingsDecryptionResult decryptedSettings;

    public AuthConfigFactory(Settings mavenSettings, SettingsDecrypter settingsDecrypter) {
        this.mavenSettings = mavenSettings;
        DefaultSettingsDecryptionRequest defaultSettingsDecryptionRequest = new DefaultSettingsDecryptionRequest(mavenSettings);
        this.decryptedSettings = settingsDecrypter.decrypt((SettingsDecryptionRequest)defaultSettingsDecryptionRequest);
    }

    public Optional<AuthConfig> getAuthConfigForRegistry(String registry) {
        Server server = this.mavenSettings.getServer(registry);
        Optional<AuthConfig> authConfigOptional = server == null ? Optional.empty() : Optional.ofNullable(this.lookupAuthConfigForRegistry(registry));
        return authConfigOptional;
    }

    private AuthConfig lookupAuthConfigForRegistry(String registry) {
        for (Server server : this.decryptedSettings.getServers()) {
            if (!registry.equals(server.getId())) continue;
            return new AuthConfig(registry, server.getUsername(), server.getPassword());
        }
        return null;
    }
}

