/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.image.single;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.lexemmens.podman.config.image.AbstractImageBuildConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SingleImageBuildConfiguration
extends AbstractImageBuildConfiguration {
    public void validate(MavenProject project, Log log, boolean failOnMissingContainerfile) throws MojoExecutionException {
        super.validate(project);
        Path sourceContainerFile = this.getSourceContainerFileDir();
        if (!Files.exists(sourceContainerFile, new LinkOption[0]) && failOnMissingContainerfile) {
            String msg = "No Containerfile found at " + sourceContainerFile + ". Check your the containerFileDir and containerFile parameters in the configuration.";
            log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        if (!Files.exists(sourceContainerFile, new LinkOption[0])) {
            log.warn((CharSequence)("No Containerfile was found at " + sourceContainerFile + ", however this will be ignored due to current plugin configuration."));
            this.valid = false;
        } else {
            if (this.isContainerFileEmpty(log, sourceContainerFile)) {
                String msg = "The specified Containerfile at " + sourceContainerFile + " is empty!";
                log.error((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
            this.determineBuildStages(log, sourceContainerFile);
            this.valid = true;
        }
    }

    public Path getSourceContainerFileDir() {
        Path containerFileDirPath = Paths.get(this.containerFileDir.toURI());
        return containerFileDirPath.resolve(this.containerFile);
    }
}

