/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.enumeration.BuildahCommand;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class BuildahExecutorService {
    private static final File BASE_DIR = new File(".");
    private final Log log;
    private final CommandExecutorDelegate delegate;
    private final File podmanRoot;

    public BuildahExecutorService(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
        this.log = log;
        this.delegate = delegate;
        this.podmanRoot = podmanConfig.getRoot();
    }

    public void cleanupLocalContainerStorage() throws MojoExecutionException {
        if (this.podmanRoot == null) {
            this.log.info((CharSequence)"Podman root storage location is set to its defaults. Not cleaning up this storage location.");
            return;
        }
        ArrayList<String> subCommand = new ArrayList<String>();
        subCommand.add("rm");
        subCommand.add("-rf");
        subCommand.add(this.podmanRoot.getAbsolutePath());
        this.runCommand(BuildahCommand.UNSHARE, subCommand);
    }

    private List<String> decorateCommands(BuildahCommand podmanCommand, List<String> subCommands) {
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(BuildahCommand.BUILDAH.getCommand());
        fullCommand.add(podmanCommand.getCommand());
        fullCommand.addAll(subCommands);
        return fullCommand;
    }

    private List<String> runCommand(BuildahCommand command, List<String> subCommands) throws MojoExecutionException {
        List<String> fullCommand = this.decorateCommands(command, subCommands);
        String msg = String.format("Executing command '%s' from basedir %s", StringUtils.join(fullCommand, (String)" "), BASE_DIR.getAbsolutePath());
        this.log.debug((CharSequence)msg);
        ProcessExecutor processExecutor = new ProcessExecutor().directory(BASE_DIR).command(fullCommand).readOutput(true).redirectOutput((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asInfo()).redirectError((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asError()).exitValueNormal();
        return this.delegate.executeCommand(processExecutor);
    }
}

