/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;

public class ContainerfileDecorator {
    private static final String LABEL_ATTRIBUTE = "LABEL ";
    private static final String BASE_IMAGE_ATTRIBUTE = "FROM";
    private final Log log;
    private final MavenFileFilter mavenFileFilter;
    private final MavenProject mavenProject;

    public ContainerfileDecorator(Log log, MavenFileFilter mavenFileFilter, MavenProject mavenProject) {
        this.log = log;
        this.mavenFileFilter = mavenFileFilter;
        this.mavenProject = mavenProject;
    }

    public void decorateContainerfile(SingleImageConfiguration image) throws MojoExecutionException {
        this.filterContainerfile(image);
        this.addLabelsToContainerfile(image);
    }

    private void filterContainerfile(SingleImageConfiguration image) throws MojoExecutionException {
        this.log.debug((CharSequence)("Filtering Containerfile. Source: " + image.getBuild().getSourceContainerFileDir() + ", target: " + image.getBuild().getTargetContainerFile()));
        try {
            MavenFileFilterRequest fileFilterRequest = new MavenFileFilterRequest();
            fileFilterRequest.setEncoding("UTF8");
            fileFilterRequest.setFiltering(true);
            fileFilterRequest.setFrom(image.getBuild().getSourceContainerFileDir().toFile());
            fileFilterRequest.setTo(image.getBuild().getTargetContainerFile().toFile());
            fileFilterRequest.setMavenProject(this.mavenProject);
            Path targetContainerFileParent = image.getBuild().getTargetContainerFile().getParent();
            if (!Files.exists(targetContainerFileParent, new LinkOption[0])) {
                Files.createDirectories(targetContainerFileParent, new FileAttribute[0]);
            }
            this.mavenFileFilter.copyFile(fileFilterRequest);
        }
        catch (MavenFilteringException e) {
            String msg = "Failed to filter Containerfile! " + e.getMessage();
            this.log.error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        catch (IOException e) {
            String msg = "Failed to create target directory for Containerfile! " + e.getMessage();
            this.log.error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)e);
        }
    }

    private void addLabelsToContainerfile(SingleImageConfiguration image) throws MojoExecutionException {
        if (image.getBuild().getLabels().isEmpty()) {
            this.log.debug((CharSequence)"No labels to add to the Containerfile");
            return;
        }
        StringBuilder labelBuilder = new StringBuilder(LABEL_ATTRIBUTE);
        for (Map.Entry<String, String> label : image.getBuild().getLabels().entrySet()) {
            labelBuilder.append(label.getKey()).append("=\"").append(label.getValue()).append("\" ");
        }
        String targetLabels = labelBuilder.toString();
        try (Stream<String> containerFileStream = Files.lines(image.getBuild().getTargetContainerFile());){
            List containerFileContents = containerFileStream.collect(Collectors.toList());
            ArrayList<String> targetContainerFileContents = new ArrayList<String>();
            for (String line : containerFileContents) {
                targetContainerFileContents.add(line);
                if (!line.startsWith(BASE_IMAGE_ATTRIBUTE)) continue;
                targetContainerFileContents.add(targetLabels);
            }
            Files.write(image.getBuild().getTargetContainerFile(), targetContainerFileContents, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            String msg = "Failed to add labels (" + targetLabels + ") to Containerfile: " + e.getMessage();
            this.log.error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)e);
        }
    }
}

