/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.enumeration.PodmanCommand;
import nl.lexemmens.podman.enumeration.TlsVerify;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class PodmanExecutorService {
    private static final String SQUASH_CMD = "--squash";
    private static final String SQUASH_ALL_CMD = "--squash-all";
    private static final String BUILD_FORMAT_CMD = "--format=";
    private static final String LAYERS_CMD = "--layers=";
    private static final String SAVE_FORMAT_CMD = "--format=oci-archive";
    private static final String OUTPUT_CMD = "--output";
    private static final String CONTAINERFILE_CMD = "--file=";
    private static final String NO_CACHE_CMD = "--no-cache=";
    private static final String PULL_CMD = "--pull=";
    private static final String PULL_ALWAYS_CMD = "--pull-always=";
    private static final String ROOT_CMD = "--root=";
    private static final String RUNROOT_CMD = "--runroot=";
    private static final File BASE_DIR = new File(".");
    private final Log log;
    private final TlsVerify tlsVerify;
    private final CommandExecutorDelegate delegate;
    private final File podmanRoot;
    private final File podmanRunRoot;
    private final File podmanRunDirectory;

    public PodmanExecutorService(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate) {
        this.log = log;
        this.delegate = delegate;
        this.tlsVerify = podmanConfig.getTlsVerify();
        this.podmanRoot = podmanConfig.getRoot();
        this.podmanRunRoot = podmanConfig.getRunRoot();
        this.podmanRunDirectory = podmanConfig.getRunDirectory();
    }

    public List<String> build(SingleImageConfiguration image) throws MojoExecutionException {
        ArrayList<String> subCommand = new ArrayList<String>();
        if (Boolean.TRUE == image.getBuild().getSquash()) {
            subCommand.add(SQUASH_CMD);
        }
        if (Boolean.TRUE == image.getBuild().getSquashAll()) {
            subCommand.add(SQUASH_ALL_CMD);
        }
        if (image.getBuild().getLayers() != null) {
            subCommand.add(LAYERS_CMD + image.getBuild().getLayers());
        }
        subCommand.add(BUILD_FORMAT_CMD + image.getBuild().getFormat().getValue());
        subCommand.add(CONTAINERFILE_CMD + image.getBuild().getTargetContainerFile());
        subCommand.add(NO_CACHE_CMD + image.getBuild().isNoCache());
        if (image.getBuild().getPull().isPresent()) {
            subCommand.add(PULL_CMD + image.getBuild().getPull().get());
        }
        if (image.getBuild().getPullAlways().isPresent()) {
            subCommand.add(PULL_ALWAYS_CMD + image.getBuild().getPullAlways().get());
        }
        subCommand.add(".");
        return this.runCommand(this.podmanRunDirectory, false, PodmanCommand.BUILD, subCommand);
    }

    public void tag(String imageHash, String fullImageName) throws MojoExecutionException {
        this.runCommand(PodmanCommand.TAG, Arrays.asList(imageHash, fullImageName));
    }

    public void save(String archiveName, String fullImageName) throws MojoExecutionException {
        ArrayList<String> subCommand = new ArrayList<String>();
        subCommand.add(SAVE_FORMAT_CMD);
        subCommand.add(OUTPUT_CMD);
        subCommand.add(archiveName);
        subCommand.add(fullImageName);
        this.runCommand(PodmanCommand.SAVE, subCommand);
    }

    public void push(String fullImageName) throws MojoExecutionException {
        this.runCommand(BASE_DIR, false, PodmanCommand.PUSH, Collections.singletonList(fullImageName));
    }

    public void login(String registry, String username, String password) throws MojoExecutionException {
        ArrayList<String> subCommand = new ArrayList<String>();
        subCommand.add(registry);
        subCommand.add("-u");
        subCommand.add(username);
        subCommand.add("-p");
        subCommand.add(password);
        try {
            this.runCommand(PodmanCommand.LOGIN, subCommand);
        }
        catch (MojoExecutionException e) {
            String message = e.getMessage().replaceAll(String.format("-p[, ]+%s", Pattern.quote(password)), "-p **********");
            this.log.error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    public void version() throws MojoExecutionException {
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(PodmanCommand.PODMAN.getCommand());
        fullCommand.add(PodmanCommand.VERSION.getCommand());
        this.runCommand(fullCommand, BASE_DIR, true);
    }

    public void removeLocalImage(String fullImageName) throws MojoExecutionException {
        this.runCommand(PodmanCommand.RMI, Collections.singletonList(fullImageName));
    }

    private List<String> decorateCommands(PodmanCommand podmanCommand, List<String> subCommands) {
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add(PodmanCommand.PODMAN.getCommand());
        if (this.podmanRoot != null) {
            fullCommand.add(ROOT_CMD + this.podmanRoot.getAbsolutePath());
        }
        if (this.podmanRunRoot != null) {
            fullCommand.add(RUNROOT_CMD + this.podmanRunRoot.getAbsolutePath());
        }
        fullCommand.add(podmanCommand.getCommand());
        if (this.isTlsSupported(podmanCommand) && this.tlsVerify != null && !TlsVerify.NOT_SPECIFIED.equals((Object)this.tlsVerify)) {
            fullCommand.add(this.tlsVerify.getCommand());
        }
        fullCommand.addAll(subCommands);
        return fullCommand;
    }

    private boolean isTlsSupported(PodmanCommand podmanCommand) {
        return !PodmanCommand.TAG.equals((Object)podmanCommand) && !PodmanCommand.SAVE.equals((Object)podmanCommand) && !PodmanCommand.RMI.equals((Object)podmanCommand);
    }

    private List<String> runCommand(File workDir, boolean redirectError, PodmanCommand command, List<String> subCommands) throws MojoExecutionException {
        List<String> fullCommand = this.decorateCommands(command, subCommands);
        return this.runCommand(fullCommand, workDir, redirectError);
    }

    private void runCommand(PodmanCommand command, List<String> subCommands) throws MojoExecutionException {
        this.runCommand(BASE_DIR, true, command, subCommands);
    }

    private List<String> runCommand(List<String> fullCommand, File workDir, boolean redirectError) throws MojoExecutionException {
        String msg = String.format("Executing command '%s' from basedir %s", StringUtils.join(fullCommand, (String)" "), BASE_DIR.getAbsolutePath());
        this.log.debug((CharSequence)msg);
        ProcessExecutor processExecutor = new ProcessExecutor().directory(workDir).command(fullCommand).readOutput(true).redirectOutput((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asInfo()).exitValueNormal();
        if (redirectError) {
            processExecutor.redirectError((OutputStream)Slf4jStream.of((String)this.getClass().getSimpleName()).asError());
        }
        return this.delegate.executeCommand(processExecutor);
    }
}

