/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegateImpl;
import nl.lexemmens.podman.service.AuthenticationService;
import nl.lexemmens.podman.service.BuildahExecutorService;
import nl.lexemmens.podman.service.ContainerfileDecorator;
import nl.lexemmens.podman.service.PodmanExecutorService;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenFileFilter;

public class ServiceHub {
    private final PodmanExecutorService podmanExecutorService;
    private final BuildahExecutorService buildahExecutorService;
    private final ContainerfileDecorator containerfileDecorator;
    private final AuthenticationService authenticationService;

    ServiceHub(Log log, MavenProject mavenProject, MavenFileFilter mavenFileFilter, PodmanConfiguration podmanConfig, Settings mavenSettings, SettingsDecrypter settingsDecrypter) {
        this.podmanExecutorService = new PodmanExecutorService(log, podmanConfig, new CommandExecutorDelegateImpl());
        this.buildahExecutorService = new BuildahExecutorService(log, podmanConfig, new CommandExecutorDelegateImpl());
        this.containerfileDecorator = new ContainerfileDecorator(log, mavenFileFilter, mavenProject);
        this.authenticationService = new AuthenticationService(log, this.podmanExecutorService, mavenSettings, settingsDecrypter);
    }

    public ContainerfileDecorator getContainerfileDecorator() {
        return this.containerfileDecorator;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public PodmanExecutorService getPodmanExecutorService() {
        return this.podmanExecutorService;
    }

    public BuildahExecutorService getBuildahExecutorService() {
        return this.buildahExecutorService;
    }
}

