/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.squareup.moshi.internal;

import java.io.IOException;
import javax.annotation.Nullable;
import shadow.com.squareup.moshi.JsonAdapter;
import shadow.com.squareup.moshi.JsonReader;
import shadow.com.squareup.moshi.JsonWriter;

public final class NullSafeJsonAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;

    public NullSafeJsonAdapter(JsonAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public JsonAdapter<T> delegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public T fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return reader.nextNull();
        }
        return this.delegate.fromJson(reader);
    }

    @Override
    public void toJson(JsonWriter writer, @Nullable T value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else {
            this.delegate.toJson(writer, value);
        }
    }

    public String toString() {
        return this.delegate + ".nullSafe()";
    }
}

