/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.vcu;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.littlerobots.vcu.VersionCatalogWriter;
import nl.littlerobots.vcu.model.HasVersion;
import nl.littlerobots.vcu.model.Library;
import nl.littlerobots.vcu.model.Plugin;
import nl.littlerobots.vcu.model.VersionCatalog;
import nl.littlerobots.vcu.model.VersionDefinition;
import shadow.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J,\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lnl/littlerobots/vcu/VersionCatalogWriter;", "", "()V", "formatLibrary", "", "library", "Lnl/littlerobots/vcu/model/Library;", "formatPlugin", "plugin", "Lnl/littlerobots/vcu/model/Plugin;", "formatVersion", "versionDefinition", "Lnl/littlerobots/vcu/model/VersionDefinition;", "write", "", "versionCatalog", "Lnl/littlerobots/vcu/model/VersionCatalog;", "writer", "Ljava/io/Writer;", "commentEntry", "Lkotlin/Function1;", "Lnl/littlerobots/vcu/model/HasVersion;", "", "writeBundles", "printWriter", "Ljava/io/PrintWriter;", "writeLibraries", "writeNewLine", "shouldAddNewLine", "writePlugins", "writeVersions", "catalog"})
public final class VersionCatalogWriter {
    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull VersionCatalog versionCatalog, @NotNull Writer writer, @NotNull Function1<? super HasVersion, Boolean> commentEntry) {
        Intrinsics.checkNotNullParameter((Object)versionCatalog, (String)"versionCatalog");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(commentEntry, (String)"commentEntry");
        PrintWriter printWriter = new PrintWriter(writer);
        boolean shouldAddNewLine = false;
        int n = 0;
        int n2 = ((Collection)versionCatalog.getTableOrder$catalog()).size();
        while (n < n2) {
            void i;
            switch (versionCatalog.getTableOrder$catalog().get((int)i)) {
                case "versions": {
                    Object object = versionCatalog.getVersions();
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeVersions(versionCatalog, printWriter);
                    shouldAddNewLine = true;
                    break;
                }
                case "libraries": {
                    Object object = versionCatalog.getLibraries();
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeLibraries(versionCatalog, printWriter, commentEntry);
                    shouldAddNewLine = true;
                    break;
                }
                case "bundles": {
                    Object object = versionCatalog.getBundles();
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeBundles(versionCatalog, printWriter);
                    shouldAddNewLine = true;
                    break;
                }
                case "plugins": {
                    Object object = versionCatalog.getPlugins();
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writePlugins(versionCatalog, printWriter, commentEntry);
                    shouldAddNewLine = true;
                    break;
                }
                default: {
                    Object object = "Unknown table " + versionCatalog.getTableOrder$catalog().get((int)i);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
            }
            ++i;
        }
        printWriter.flush();
        printWriter.close();
    }

    public static /* synthetic */ void write$default(VersionCatalogWriter versionCatalogWriter, VersionCatalog versionCatalog, Writer writer, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = write.1.INSTANCE;
        }
        versionCatalogWriter.write(versionCatalog, writer, (Function1<? super HasVersion, Boolean>)function1);
    }

    private final void writePlugins(VersionCatalog versionCatalog, PrintWriter printWriter, Function1<? super HasVersion, Boolean> commentEntry) {
        for (String string : versionCatalog.getPluginComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[plugins]");
        Map<String, Plugin> map = versionCatalog.getPlugins();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            for (String comment : versionCatalog.getPluginComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            if (((Boolean)commentEntry.invoke(entry.getValue())).booleanValue()) {
                printWriter.print("#");
            }
            printWriter.println((String)entry.getKey() + " = " + this.formatPlugin((Plugin)entry.getValue()));
        }
    }

    private final void writeBundles(VersionCatalog versionCatalog, PrintWriter printWriter) {
        for (String string : versionCatalog.getBundleComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[bundles]");
        Map<String, List<String>> map = versionCatalog.getBundles();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            for (String comment : versionCatalog.getBundleComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            String bundleStart = (String)entry.getKey() + " = [";
            Function1 function1 = writeBundles.1.INSTANCE;
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = System.lineSeparator() + "]";
            CharSequence charSequence3 = System.lineSeparator() + StringsKt.repeat((CharSequence)" ", (int)4);
            CharSequence charSequence4 = bundleStart + System.lineSeparator() + StringsKt.repeat((CharSequence)" ", (int)4);
            printWriter.println(CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), (CharSequence)charSequence3, (CharSequence)charSequence4, (CharSequence)charSequence2, (int)n, charSequence, (Function1)function1, (int)24, null));
        }
    }

    private final void writeLibraries(VersionCatalog versionCatalog, PrintWriter printWriter, Function1<? super HasVersion, Boolean> commentEntry) {
        for (String string : versionCatalog.getLibraryComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[libraries]");
        Map<String, Library> map = versionCatalog.getLibraries();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            for (String comment : versionCatalog.getLibraryComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            if (((Boolean)commentEntry.invoke(entry.getValue())).booleanValue()) {
                printWriter.print("#");
            }
            printWriter.println((String)entry.getKey() + " = " + this.formatLibrary((Library)entry.getValue()));
        }
    }

    private final void writeNewLine(PrintWriter writer, boolean shouldAddNewLine) {
        if (shouldAddNewLine) {
            writer.println();
        }
    }

    private final void writeVersions(VersionCatalog versionCatalog, PrintWriter printWriter) {
        for (String string : versionCatalog.getVersionComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[versions]");
        Map<String, VersionDefinition> map = versionCatalog.getVersions();
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            for (String comment : versionCatalog.getVersionComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            printWriter.println((String)entry.getKey() + " = " + this.formatVersion((VersionDefinition)entry.getValue()));
        }
    }

    private final String formatPlugin(Plugin plugin) {
        String string;
        VersionDefinition versionDefinition = plugin.getVersion();
        if (versionDefinition instanceof VersionDefinition.Simple) {
            string = '\"' + plugin.getId() + ':' + ((VersionDefinition.Simple)plugin.getVersion()).getVersion() + '\"';
        } else if (versionDefinition instanceof VersionDefinition.Reference) {
            string = "{ id = \"" + plugin.getId() + "\", version.ref = \"" + ((VersionDefinition.Reference)plugin.getVersion()).getRef() + "\" }";
        } else if (versionDefinition instanceof VersionDefinition.Condition) {
            Map<String, String> conditions;
            StringBuilder stringBuilder = new StringBuilder("{ id = \"" + plugin.getId() + "\", version = { ");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder $this$apply = stringBuilder;
            boolean bl3 = false;
            Map<String, String> map = conditions = ((VersionDefinition.Condition)plugin.getVersion()).getDefinition();
            boolean bl4 = false;
            for (Map.Entry<String, String> condition : map.entrySet()) {
                $this$apply.append(condition.getKey() + " = \"" + condition.getValue() + "\", ");
            }
            $this$apply.setLength($this$apply.length() - 2);
            $this$apply.append(" } }");
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(\"{ id = \\\"\u2026\n            }.toString()");
        } else if (versionDefinition instanceof VersionDefinition.Unspecified) {
            string = "{ id = \"" + plugin.getId() + "\" }";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String formatLibrary(Library library) {
        String string;
        VersionDefinition versionDefinition = library.getVersion();
        if (versionDefinition instanceof VersionDefinition.Simple) {
            string = '\"' + library.getModule() + ':' + ((VersionDefinition.Simple)library.getVersion()).getVersion() + '\"';
        } else if (versionDefinition instanceof VersionDefinition.Reference) {
            string = "{ module = \"" + library.getModule() + "\", version.ref = \"" + ((VersionDefinition.Reference)library.getVersion()).getRef() + "\" }";
        } else if (versionDefinition instanceof VersionDefinition.Condition) {
            Map<String, String> conditions;
            StringBuilder stringBuilder = new StringBuilder("{ module = \"" + library.getModule() + "\", version = { ");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder $this$apply = stringBuilder;
            boolean bl3 = false;
            Map<String, String> map = conditions = ((VersionDefinition.Condition)library.getVersion()).getDefinition();
            boolean bl4 = false;
            for (Map.Entry<String, String> condition : map.entrySet()) {
                $this$apply.append(condition.getKey() + " = \"" + condition.getValue() + "\", ");
            }
            $this$apply.setLength($this$apply.length() - 2);
            $this$apply.append(" } }");
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(\"\"\"{ modul\u2026\n            }.toString()");
        } else if (versionDefinition instanceof VersionDefinition.Unspecified) {
            string = "{ module = \"" + library.getModule() + "\" }";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String formatVersion(VersionDefinition versionDefinition) {
        String string;
        VersionDefinition versionDefinition2 = versionDefinition;
        if (versionDefinition2 instanceof VersionDefinition.Simple) {
            string = '\"' + ((VersionDefinition.Simple)versionDefinition).getVersion() + '\"';
        } else if (versionDefinition2 instanceof VersionDefinition.Condition) {
            Function1 function1 = formatVersion.1.INSTANCE;
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = ", ";
            CharSequence charSequence3 = " }";
            CharSequence charSequence4 = "{ ";
            string = CollectionsKt.joinToString$default((Iterable)((VersionDefinition.Condition)versionDefinition).getDefinition().entrySet(), (CharSequence)charSequence2, (CharSequence)charSequence4, (CharSequence)charSequence3, (int)n, charSequence, (Function1)function1, (int)24, null);
        } else {
            throw (Throwable)new IllegalStateException("Invalid version definition " + versionDefinition);
        }
        return string;
    }
}

