/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.dataformat.toml;

class StringOutputUtil {
    public static final int UNQUOTED_KEY = 1;
    public static final int LITERAL_STRING = 2;
    public static final int BASIC_STRING = 4;
    public static final int BASIC_STRING_NO_ESCAPE = 8;
    public static final int ASCII_ONLY = 16;
    private static final int EMPTY_STRING_CATS = 30;
    public static final int MASK_SIMPLE_KEY = -1;
    public static final int MASK_STRING = -2;

    StringOutputUtil() {
    }

    static int categorize(String s) {
        if (s.isEmpty()) {
            return 30;
        }
        int flags = -1;
        int i = 0;
        while (i < s.length()) {
            char hi;
            if (Character.isHighSurrogate(hi = s.charAt(i++)) && i < s.length()) {
                char lo = s.charAt(i);
                if (Character.isLowSurrogate(lo)) {
                    ++i;
                    flags &= StringOutputUtil.categorize(Character.toCodePoint(hi, lo));
                    continue;
                }
                return 0;
            }
            flags &= StringOutputUtil.categorize(hi);
        }
        return flags;
    }

    static int categorize(char[] text, int offset, int len) {
        if (len == 0) {
            return 30;
        }
        int flags = -1;
        int i = 0;
        while (i < len) {
            char hi;
            if (Character.isHighSurrogate(hi = text[offset + i++]) && i < len) {
                char lo = text[offset + i];
                if (Character.isLowSurrogate(lo)) {
                    ++i;
                    flags &= StringOutputUtil.categorize(Character.toCodePoint(hi, lo));
                    continue;
                }
                return 0;
            }
            flags &= StringOutputUtil.categorize(hi);
        }
        return flags;
    }

    static int categorize(int c) {
        if (c > 0x10FFFF || c >= 55296 && c <= 57343) {
            return 0;
        }
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 45 || c == 95) {
            return 31;
        }
        if (c >= 128) {
            return 14;
        }
        if (c == 34) {
            return 22;
        }
        if (c == 39) {
            return 28;
        }
        if (c == 92) {
            return 22;
        }
        if (c == 9 || c >= 32 && c <= 126) {
            return 30;
        }
        return 20;
    }

    static String getBasicStringEscape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < '\u0010') {
            return "\\u000" + Integer.toHexString(c);
        }
        if (c < ' ' || c == '\u007f') {
            return "\\u00" + Integer.toHexString(c);
        }
        return null;
    }
}

