/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.vcu;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.littlerobots.vcu.model.HasVersion;
import nl.littlerobots.vcu.model.Library;
import nl.littlerobots.vcu.model.Plugin;
import nl.littlerobots.vcu.model.VersionCatalog;
import nl.littlerobots.vcu.model.VersionDefinition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u0017*\u00020\u0001H\u0002\u00a8\u0006!"}, d2={"Lnl/littlerobots/vcu/VersionCatalogWriter;", "", "<init>", "()V", "write", "", "versionCatalog", "Lnl/littlerobots/vcu/model/VersionCatalog;", "writer", "Ljava/io/Writer;", "commentEntry", "Lkotlin/Function1;", "Lnl/littlerobots/vcu/model/HasVersion;", "", "writePlugins", "printWriter", "Ljava/io/PrintWriter;", "writeBundles", "writeLibraries", "writeNewLine", "shouldAddNewLine", "writeVersions", "formatPlugin", "", "plugin", "Lnl/littlerobots/vcu/model/Plugin;", "formatLibrary", "library", "Lnl/littlerobots/vcu/model/Library;", "formatVersion", "versionDefinition", "Lnl/littlerobots/vcu/model/VersionDefinition;", "formatValue", "catalog"})
public final class VersionCatalogWriter {
    public final void write(@NotNull VersionCatalog versionCatalog, @NotNull Writer writer, @NotNull Function1<? super HasVersion, Boolean> commentEntry) {
        Intrinsics.checkNotNullParameter((Object)versionCatalog, (String)"versionCatalog");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(commentEntry, (String)"commentEntry");
        PrintWriter printWriter = new PrintWriter(writer);
        boolean shouldAddNewLine = false;
        int n = ((Collection)versionCatalog.getTableOrder$catalog()).size();
        block12: for (int i = 0; i < n; ++i) {
            switch (versionCatalog.getTableOrder$catalog().get(i)) {
                case "versions": {
                    if (!(!versionCatalog.getVersions().isEmpty())) continue block12;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeVersions(versionCatalog, printWriter);
                    shouldAddNewLine = true;
                    continue block12;
                }
                case "libraries": {
                    if (!(!versionCatalog.getLibraries().isEmpty())) continue block12;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeLibraries(versionCatalog, printWriter, commentEntry);
                    shouldAddNewLine = true;
                    continue block12;
                }
                case "bundles": {
                    if (!(!versionCatalog.getBundles().isEmpty())) continue block12;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writeBundles(versionCatalog, printWriter);
                    shouldAddNewLine = true;
                    continue block12;
                }
                case "plugins": {
                    if (!(!versionCatalog.getPlugins().isEmpty())) continue block12;
                    this.writeNewLine(printWriter, shouldAddNewLine);
                    this.writePlugins(versionCatalog, printWriter, commentEntry);
                    shouldAddNewLine = true;
                    continue block12;
                }
                default: {
                    throw new IllegalStateException(("Unknown table " + versionCatalog.getTableOrder$catalog().get(i)).toString());
                }
            }
        }
        printWriter.flush();
        printWriter.close();
    }

    public static /* synthetic */ void write$default(VersionCatalogWriter versionCatalogWriter, VersionCatalog versionCatalog, Writer writer, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = VersionCatalogWriter::write$lambda$0;
        }
        versionCatalogWriter.write(versionCatalog, writer, (Function1<? super HasVersion, Boolean>)function1);
    }

    private final void writePlugins(VersionCatalog versionCatalog, PrintWriter printWriter, Function1<? super HasVersion, Boolean> commentEntry) {
        for (String string : versionCatalog.getPluginComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[plugins]");
        for (Map.Entry entry : versionCatalog.getPlugins().entrySet()) {
            for (String comment : versionCatalog.getPluginComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            if (((Boolean)commentEntry.invoke(entry.getValue())).booleanValue()) {
                printWriter.print("#");
            }
            printWriter.println(entry.getKey() + " = " + this.formatPlugin((Plugin)entry.getValue()));
        }
    }

    private final void writeBundles(VersionCatalog versionCatalog, PrintWriter printWriter) {
        for (String string : versionCatalog.getBundleComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[bundles]");
        for (Map.Entry entry : versionCatalog.getBundles().entrySet()) {
            for (String comment : versionCatalog.getBundleComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            String bundleStart = entry.getKey() + " = [";
            List list = (List)entry.getValue();
            String string = bundleStart + System.lineSeparator() + StringsKt.repeat((CharSequence)" ", (int)4);
            String string2 = System.lineSeparator() + StringsKt.repeat((CharSequence)" ", (int)4);
            String string3 = System.lineSeparator() + "]";
            printWriter.println(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)string2, (CharSequence)string, (CharSequence)string3, (int)0, null, VersionCatalogWriter::writeBundles$lambda$1, (int)24, null));
        }
    }

    private final void writeLibraries(VersionCatalog versionCatalog, PrintWriter printWriter, Function1<? super HasVersion, Boolean> commentEntry) {
        for (String string : versionCatalog.getLibraryComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[libraries]");
        for (Map.Entry entry : versionCatalog.getLibraries().entrySet()) {
            for (String comment : versionCatalog.getLibraryComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            if (((Boolean)commentEntry.invoke(entry.getValue())).booleanValue()) {
                printWriter.print("#");
            }
            printWriter.println(entry.getKey() + " = " + this.formatLibrary((Library)entry.getValue()));
        }
    }

    private final void writeNewLine(PrintWriter writer, boolean shouldAddNewLine) {
        if (shouldAddNewLine) {
            writer.println();
        }
    }

    private final void writeVersions(VersionCatalog versionCatalog, PrintWriter printWriter) {
        for (String string : versionCatalog.getVersionComments().getTableComments()) {
            printWriter.println(string);
        }
        printWriter.println("[versions]");
        for (Map.Entry entry : versionCatalog.getVersions().entrySet()) {
            for (String comment : versionCatalog.getVersionComments().getCommentsForKey((String)entry.getKey())) {
                printWriter.println(comment);
            }
            printWriter.println(entry.getKey() + " = " + this.formatVersion((VersionDefinition)entry.getValue()));
        }
    }

    private final String formatPlugin(Plugin plugin) {
        Object object;
        VersionDefinition versionDefinition = plugin.getVersion();
        if (versionDefinition instanceof VersionDefinition.Simple) {
            object = "\"" + plugin.getId() + ":" + ((VersionDefinition.Simple)plugin.getVersion()).getVersion() + "\"";
        } else if (versionDefinition instanceof VersionDefinition.Reference) {
            object = "{ id = \"" + plugin.getId() + "\", version.ref = \"" + ((VersionDefinition.Reference)plugin.getVersion()).getRef() + "\" }";
        } else if (versionDefinition instanceof VersionDefinition.Condition) {
            StringBuilder stringBuilder;
            StringBuilder $this$formatPlugin_u24lambda_u242 = stringBuilder = new StringBuilder("{ id = \"" + plugin.getId() + "\", version = { ");
            boolean bl = false;
            Map<String, Object> conditions = ((VersionDefinition.Condition)plugin.getVersion()).getDefinition();
            for (Map.Entry<String, Object> condition : conditions.entrySet()) {
                $this$formatPlugin_u24lambda_u242.append(condition.getKey() + " = \"" + condition.getValue() + "\", ");
            }
            $this$formatPlugin_u24lambda_u242.setLength($this$formatPlugin_u24lambda_u242.length() - 2);
            $this$formatPlugin_u24lambda_u242.append(" } }");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else if (versionDefinition instanceof VersionDefinition.Unspecified) {
            object = "{ id = \"" + plugin.getId() + "\" }";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final String formatLibrary(Library library) {
        Object object;
        VersionDefinition versionDefinition = library.getVersion();
        if (versionDefinition instanceof VersionDefinition.Simple) {
            object = "\"" + library.getModule() + ":" + ((VersionDefinition.Simple)library.getVersion()).getVersion() + "\"";
        } else if (versionDefinition instanceof VersionDefinition.Reference) {
            object = "{ module = \"" + library.getModule() + "\", version.ref = \"" + ((VersionDefinition.Reference)library.getVersion()).getRef() + "\" }";
        } else if (versionDefinition instanceof VersionDefinition.Condition) {
            StringBuilder stringBuilder;
            StringBuilder $this$formatLibrary_u24lambda_u243 = stringBuilder = new StringBuilder("{ module = \"" + library.getModule() + "\", version = { ");
            boolean bl = false;
            Map<String, Object> conditions = ((VersionDefinition.Condition)library.getVersion()).getDefinition();
            for (Map.Entry<String, Object> condition : conditions.entrySet()) {
                $this$formatLibrary_u24lambda_u243.append(condition.getKey() + " = " + this.formatValue(condition.getValue()) + ", ");
            }
            $this$formatLibrary_u24lambda_u243.setLength($this$formatLibrary_u24lambda_u243.length() - 2);
            $this$formatLibrary_u24lambda_u243.append(" } }");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else if (versionDefinition instanceof VersionDefinition.Unspecified) {
            object = "{ module = \"" + library.getModule() + "\" }";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final String formatVersion(VersionDefinition versionDefinition) {
        Object object;
        VersionDefinition versionDefinition2 = versionDefinition;
        if (versionDefinition2 instanceof VersionDefinition.Simple) {
            object = "\"" + ((VersionDefinition.Simple)versionDefinition).getVersion() + "\"";
        } else if (versionDefinition2 instanceof VersionDefinition.Condition) {
            object = CollectionsKt.joinToString$default((Iterable)((VersionDefinition.Condition)versionDefinition).getDefinition().entrySet(), (CharSequence)", ", (CharSequence)"{ ", (CharSequence)" }", (int)0, null, arg_0 -> VersionCatalogWriter.formatVersion$lambda$4(this, arg_0), (int)24, null);
        } else {
            throw new IllegalStateException("Invalid version definition " + versionDefinition);
        }
        return object;
    }

    private final String formatValue(Object $this$formatValue) {
        return $this$formatValue instanceof List ? CollectionsKt.joinToString$default((Iterable)((Iterable)$this$formatValue), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, VersionCatalogWriter::formatValue$lambda$5, (int)24, null) : "\"" + $this$formatValue + "\"";
    }

    private static final boolean write$lambda$0(HasVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final CharSequence writeBundles$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\",";
    }

    private static final CharSequence formatVersion$lambda$4(VersionCatalogWriter this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + " = " + this$0.formatValue(it.getValue());
    }

    private static final CharSequence formatValue$lambda$5(Object it) {
        return "\"" + it + "\"";
    }
}

