/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.vcu.plugin.resolver;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0005\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0005\u0010\u0010J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006#"}, d2={"Lnl/littlerobots/vcu/plugin/resolver/Dependency;", "", "group", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "moduleIdentifier", "Lorg/gradle/api/artifacts/ModuleIdentifier;", "(Lorg/gradle/api/artifacts/ModuleIdentifier;)V", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "(Lorg/gradle/api/artifacts/ModuleVersionIdentifier;)V", "dependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "(Lorg/gradle/api/artifacts/ResolvedDependency;)V", "Lorg/gradle/api/artifacts/UnresolvedDependency;", "(Lorg/gradle/api/artifacts/UnresolvedDependency;)V", "getGroup", "()Ljava/lang/String;", "getName", "module", "getModule", "tomlKey", "getTomlKey", "isPlugin", "", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "plugin"})
final class Dependency {
    @NotNull
    private final String group;
    @NotNull
    private final String name;

    public Dependency(@NotNull String group, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.group = group;
        this.name = name;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Dependency(@NotNull ModuleIdentifier moduleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        String string = moduleIdentifier.getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        String string2 = moduleIdentifier.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this(string, string2);
    }

    public Dependency(@NotNull ModuleVersionIdentifier moduleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        String string = moduleIdentifier.getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        String string2 = moduleIdentifier.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this(string, string2);
    }

    public Dependency(@NotNull ResolvedDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getModule().getId().getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        String string2 = dependency.getModule().getId().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this(string, string2);
    }

    public Dependency(@NotNull UnresolvedDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getSelector().getModule().getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        String string2 = dependency.getSelector().getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this(string, string2);
    }

    @NotNull
    public final String getModule() {
        return this.group + ":" + this.name;
    }

    @NotNull
    public final String getTomlKey() {
        return StringsKt.replace$default((String)this.getModule(), (String)".", (String)"-", (boolean)false, (int)4, null);
    }

    public final boolean isPlugin() {
        return StringsKt.endsWith$default((String)this.name, (String)".gradle.plugin", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String component1() {
        return this.group;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Dependency copy(@NotNull String group, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Dependency(group, name);
    }

    public static /* synthetic */ Dependency copy$default(Dependency dependency, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = dependency.group;
        }
        if ((n & 2) != 0) {
            string2 = dependency.name;
        }
        return dependency.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Dependency(group=" + this.group + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)other;
        if (!Intrinsics.areEqual((Object)this.group, (Object)dependency.group)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)dependency.name);
    }
}

