/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import nl.martijndwars.webpush.Base64Encoder;
import nl.martijndwars.webpush.ClosableCallback;
import nl.martijndwars.webpush.Encoding;
import nl.martijndwars.webpush.Encrypted;
import nl.martijndwars.webpush.HttpEce;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.Utils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHeader;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class PushService {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final String SERVER_KEY_ID = "server-key-id";
    public static final String SERVER_KEY_CURVE = "P-256";
    private String gcmApiKey;
    private String subject;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public PushService() {
    }

    public PushService(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
    }

    public PushService(KeyPair keyPair, String subject) {
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        this.subject = subject;
    }

    public PushService(String publicKey, String privateKey, String subject) throws GeneralSecurityException {
        this.publicKey = Utils.loadPublicKey(publicKey);
        this.privateKey = Utils.loadPrivateKey(privateKey);
        this.subject = subject;
    }

    public static Encrypted encrypt(byte[] payload, ECPublicKey userPublicKey, byte[] userAuth, Encoding encoding) throws GeneralSecurityException {
        KeyPair localKeyPair = PushService.generateLocalKeyPair();
        HashMap<String, KeyPair> keys = new HashMap<String, KeyPair>();
        keys.put(SERVER_KEY_ID, localKeyPair);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(SERVER_KEY_ID, SERVER_KEY_CURVE);
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        HttpEce httpEce = new HttpEce(keys, labels);
        byte[] ciphertext = httpEce.encrypt(payload, salt, null, SERVER_KEY_ID, userPublicKey, userAuth, encoding);
        return new Encrypted.Builder().withSalt(salt).withPublicKey(localKeyPair.getPublic()).withCiphertext(ciphertext).build();
    }

    private static KeyPair generateLocalKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public HttpResponse send(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException, ExecutionException, InterruptedException {
        return this.sendAsync(notification, encoding).get();
    }

    public HttpResponse send(Notification notification) throws GeneralSecurityException, IOException, JoseException, ExecutionException, InterruptedException {
        return this.send(notification, Encoding.AESGCM);
    }

    public Future<HttpResponse> sendAsync(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        HttpPost httpPost = this.preparePost(notification, encoding);
        CloseableHttpAsyncClient closeableHttpAsyncClient = HttpAsyncClients.createSystem();
        closeableHttpAsyncClient.start();
        return closeableHttpAsyncClient.execute((HttpUriRequest)httpPost, (FutureCallback)new ClosableCallback(closeableHttpAsyncClient));
    }

    public Future<HttpResponse> sendAsync(Notification notification) throws GeneralSecurityException, IOException, JoseException {
        return this.sendAsync(notification, Encoding.AES128GCM);
    }

    public HttpPost preparePost(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        if (this.privateKey != null && this.publicKey != null && !Utils.verifyKeyPair(this.privateKey, this.publicKey)) {
            throw new IllegalStateException("Public key and private key do not match.");
        }
        Encrypted encrypted = PushService.encrypt(notification.getPayload(), notification.getUserPublicKey(), notification.getUserAuth(), encoding);
        byte[] dh = Utils.encode((ECPublicKey)encrypted.getPublicKey());
        byte[] salt = encrypted.getSalt();
        HttpPost httpPost = new HttpPost(notification.getEndpoint());
        httpPost.addHeader("TTL", String.valueOf(notification.getTTL()));
        HashMap<String, String> headers = new HashMap<String, String>();
        if (notification.hasPayload()) {
            headers.put("Content-Type", "application/octet-stream");
            if (encoding == Encoding.AES128GCM) {
                headers.put("Content-Encoding", "aes128gcm");
            } else if (encoding == Encoding.AESGCM) {
                headers.put("Content-Encoding", "aesgcm");
                headers.put("Encryption", "salt=" + Base64Encoder.encodeUrlWithoutPadding(salt));
                headers.put("Crypto-Key", "dh=" + Base64Encoder.encodeUrl(dh));
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(encrypted.getCiphertext()));
        }
        if (notification.isGcm()) {
            if (this.gcmApiKey == null) {
                throw new IllegalStateException("An GCM API key is needed to send a push notification to a GCM endpoint.");
            }
            headers.put("Authorization", "key=" + this.gcmApiKey);
        } else if (this.vapidEnabled()) {
            if (encoding == Encoding.AES128GCM && notification.getEndpoint().startsWith("https://fcm.googleapis.com")) {
                httpPost.setURI(URI.create(notification.getEndpoint().replace("fcm/send", "wp")));
            }
            JwtClaims claims = new JwtClaims();
            claims.setAudience(notification.getOrigin());
            claims.setExpirationTimeMinutesInTheFuture(720.0f);
            claims.setSubject(this.subject);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setHeader("typ", "JWT");
            jws.setHeader("alg", "ES256");
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.privateKey);
            jws.setAlgorithmHeaderValue("ES256");
            byte[] pk = Utils.encode((ECPublicKey)this.publicKey);
            if (encoding == Encoding.AES128GCM) {
                headers.put("Authorization", "vapid t=" + jws.getCompactSerialization() + ", k=" + Base64Encoder.encodeUrlWithoutPadding(pk));
            } else if (encoding == Encoding.AESGCM) {
                headers.put("Authorization", "WebPush " + jws.getCompactSerialization());
            }
            if (headers.containsKey("Crypto-Key")) {
                headers.put("Crypto-Key", (String)headers.get("Crypto-Key") + ";p256ecdsa=" + Base64Encoder.encodeUrlWithoutPadding(pk));
            } else {
                headers.put("Crypto-Key", "p256ecdsa=" + Base64Encoder.encodeUrl(pk));
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            httpPost.addHeader((Header)new BasicHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        return httpPost;
    }

    public PushService setGcmApiKey(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
        return this;
    }

    public PushService setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public PushService setKeyPair(KeyPair keyPair) {
        this.setPublicKey(keyPair.getPublic());
        this.setPrivateKey(keyPair.getPrivate());
        return this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PushService setPublicKey(String publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPublicKey(Utils.loadPublicKey(publicKey));
        return this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public KeyPair getKeyPair() {
        return new KeyPair(this.publicKey, this.privateKey);
    }

    public PushService setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public PushService setPrivateKey(String privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPrivateKey(Utils.loadPrivateKey(privateKey));
        return this;
    }

    public PushService setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    protected boolean vapidEnabled() {
        return this.publicKey != null && this.privateKey != null;
    }
}

