/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.HashMap;
import nl.martijndwars.webpush.Encoding;
import nl.martijndwars.webpush.Encrypted;
import nl.martijndwars.webpush.HttpEce;
import nl.martijndwars.webpush.HttpRequest;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.Utils;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public abstract class AbstractPushService<T extends AbstractPushService<T>> {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final String SERVER_KEY_ID = "server-key-id";
    public static final String SERVER_KEY_CURVE = "P-256";
    private String gcmApiKey;
    private String subject;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public AbstractPushService() {
    }

    public AbstractPushService(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
    }

    public AbstractPushService(KeyPair keyPair) {
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public AbstractPushService(KeyPair keyPair, String subject) {
        this(keyPair);
        this.subject = subject;
    }

    public AbstractPushService(String publicKey, String privateKey) throws GeneralSecurityException {
        this.publicKey = Utils.loadPublicKey(publicKey);
        this.privateKey = Utils.loadPrivateKey(privateKey);
    }

    public AbstractPushService(String publicKey, String privateKey, String subject) throws GeneralSecurityException {
        this(publicKey, privateKey);
        this.subject = subject;
    }

    public static Encrypted encrypt(byte[] payload, ECPublicKey userPublicKey, byte[] userAuth, Encoding encoding) throws GeneralSecurityException {
        KeyPair localKeyPair = AbstractPushService.generateLocalKeyPair();
        HashMap<String, KeyPair> keys = new HashMap<String, KeyPair>();
        keys.put(SERVER_KEY_ID, localKeyPair);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(SERVER_KEY_ID, SERVER_KEY_CURVE);
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        HttpEce httpEce = new HttpEce(keys, labels);
        byte[] ciphertext = httpEce.encrypt(payload, salt, null, SERVER_KEY_ID, userPublicKey, userAuth, encoding);
        return new Encrypted.Builder().withSalt(salt).withPublicKey(localKeyPair.getPublic()).withCiphertext(ciphertext).build();
    }

    private static KeyPair generateLocalKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    protected final HttpRequest prepareRequest(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        if (this.getPrivateKey() != null && this.getPublicKey() != null && !Utils.verifyKeyPair(this.getPrivateKey(), this.getPublicKey())) {
            throw new IllegalStateException("Public key and private key do not match.");
        }
        Encrypted encrypted = AbstractPushService.encrypt(notification.getPayload(), notification.getUserPublicKey(), notification.getUserAuth(), encoding);
        byte[] dh = Utils.encode((ECPublicKey)encrypted.getPublicKey());
        byte[] salt = encrypted.getSalt();
        String url = notification.getEndpoint();
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] body = null;
        headers.put("TTL", String.valueOf(notification.getTTL()));
        if (notification.hasUrgency()) {
            headers.put("Urgency", notification.getUrgency().getHeaderValue());
        }
        if (notification.hasTopic()) {
            headers.put("Topic", notification.getTopic());
        }
        if (notification.hasPayload()) {
            headers.put("Content-Type", "application/octet-stream");
            if (encoding == Encoding.AES128GCM) {
                headers.put("Content-Encoding", "aes128gcm");
            } else if (encoding == Encoding.AESGCM) {
                headers.put("Content-Encoding", "aesgcm");
                headers.put("Encryption", "salt=" + Base64.getUrlEncoder().withoutPadding().encodeToString(salt));
                headers.put("Crypto-Key", "dh=" + Base64.getUrlEncoder().encodeToString(dh));
            }
            body = encrypted.getCiphertext();
        }
        if (notification.isGcm()) {
            if (this.getGcmApiKey() == null) {
                throw new IllegalStateException("An GCM API key is needed to send a push notification to a GCM endpoint.");
            }
            headers.put("Authorization", "key=" + this.getGcmApiKey());
        } else if (this.vapidEnabled()) {
            if (encoding == Encoding.AES128GCM && notification.getEndpoint().startsWith("https://fcm.googleapis.com")) {
                url = notification.getEndpoint().replace("fcm/send", "wp");
            }
            JwtClaims claims = new JwtClaims();
            claims.setAudience(notification.getOrigin());
            claims.setExpirationTimeMinutesInTheFuture(720.0f);
            if (this.getSubject() != null) {
                claims.setSubject(this.getSubject());
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setHeader("typ", "JWT");
            jws.setHeader("alg", "ES256");
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.getPrivateKey());
            jws.setAlgorithmHeaderValue("ES256");
            byte[] pk = Utils.encode((ECPublicKey)this.getPublicKey());
            if (encoding == Encoding.AES128GCM) {
                headers.put("Authorization", "vapid t=" + jws.getCompactSerialization() + ", k=" + Base64.getUrlEncoder().withoutPadding().encodeToString(pk));
            } else if (encoding == Encoding.AESGCM) {
                headers.put("Authorization", "WebPush " + jws.getCompactSerialization());
            }
            if (headers.containsKey("Crypto-Key")) {
                headers.put("Crypto-Key", (String)headers.get("Crypto-Key") + ";p256ecdsa=" + Base64.getUrlEncoder().encodeToString(pk));
            } else {
                headers.put("Crypto-Key", "p256ecdsa=" + Base64.getUrlEncoder().encodeToString(pk));
            }
        } else if (notification.isFcm() && this.getGcmApiKey() != null) {
            headers.put("Authorization", "key=" + this.getGcmApiKey());
        }
        return new HttpRequest(url, headers, body);
    }

    public T setGcmApiKey(String gcmApiKey) {
        this.gcmApiKey = gcmApiKey;
        return (T)this;
    }

    public String getGcmApiKey() {
        return this.gcmApiKey;
    }

    public String getSubject() {
        return this.subject;
    }

    public T setSubject(String subject) {
        this.subject = subject;
        return (T)this;
    }

    public T setKeyPair(KeyPair keyPair) {
        this.setPublicKey(keyPair.getPublic());
        this.setPrivateKey(keyPair.getPrivate());
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public T setPublicKey(String publicKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPublicKey(Utils.loadPublicKey(publicKey));
        return (T)this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public KeyPair getKeyPair() {
        return new KeyPair(this.publicKey, this.privateKey);
    }

    public T setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return (T)this;
    }

    public T setPrivateKey(String privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this.setPrivateKey(Utils.loadPrivateKey(privateKey));
        return (T)this;
    }

    public T setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return (T)this;
    }

    protected boolean vapidEnabled() {
        return this.publicKey != null && this.privateKey != null;
    }
}

