/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nl.martijndwars.webpush.Encoding;
import nl.martijndwars.webpush.Utils;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;

public class HttpEce {
    public static final int KEY_LENGTH = 16;
    public static final int SHA_256_LENGTH = 32;
    public static final int TAG_SIZE = 16;
    public static final int TWO_BYTE_MAX = 65536;
    public static final String WEB_PUSH_INFO = "WebPush: info\u0000";
    private Map<String, KeyPair> keys;
    private Map<String, String> labels;

    public HttpEce() {
        this(new HashMap<String, KeyPair>(), new HashMap<String, String>());
    }

    public HttpEce(Map<String, KeyPair> keys, Map<String, String> labels) {
        this.keys = keys;
        this.labels = labels;
    }

    public byte[] encrypt(byte[] plaintext, byte[] salt, byte[] privateKey, String keyid, ECPublicKey dh, byte[] authSecret, Encoding version) throws GeneralSecurityException {
        HttpEce.log("encrypt", plaintext);
        byte[][] keyAndNonce = this.deriveKeyAndNonce(salt, privateKey, keyid, dh, authSecret, version, 1);
        byte[] key = keyAndNonce[0];
        byte[] nonce = keyAndNonce[1];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec params = new GCMParameterSpec(128, nonce);
        cipher.init(1, (Key)new SecretKeySpec(key, "AES"), params);
        if (version == Encoding.AES128GCM) {
            byte[] header = this.buildHeader(salt, keyid);
            HttpEce.log("header", header);
            byte[] padding = new byte[]{2};
            HttpEce.log("padding", padding);
            byte[][] encrypted = new byte[][]{cipher.update(plaintext), cipher.update(padding), cipher.doFinal()};
            HttpEce.log("encrypted", Utils.concat(encrypted));
            return HttpEce.log("ciphertext", Utils.concat(header, Utils.concat(encrypted)));
        }
        return Utils.concat(cipher.update(new byte[2]), cipher.doFinal(plaintext));
    }

    public byte[] decrypt(byte[] payload, byte[] salt, byte[] key, String keyid, Encoding version) throws InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, NoSuchProviderException, NoSuchPaddingException {
        byte[] body;
        if (version == Encoding.AES128GCM) {
            byte[][] header = this.parseHeader(payload);
            salt = header[0];
            keyid = new String(header[2]);
            body = header[3];
        } else {
            body = payload;
        }
        byte[][] keyAndNonce = this.deriveKeyAndNonce(salt, key, keyid, null, null, version, 2);
        return this.decryptRecord(body, keyAndNonce[0], keyAndNonce[1], version);
    }

    public byte[][] parseHeader(byte[] payload) {
        byte[] salt = Arrays.copyOfRange(payload, 0, 16);
        byte[] recordSize = Arrays.copyOfRange(payload, 16, 20);
        byte keyIdLength = Arrays.copyOfRange(payload, 20, 21)[0];
        byte[] keyId = Arrays.copyOfRange(payload, 21, 21 + keyIdLength);
        byte[] body = Arrays.copyOfRange(payload, 21 + keyIdLength, payload.length);
        return new byte[][]{salt, recordSize, keyId, body};
    }

    public byte[] decryptRecord(byte[] ciphertext, byte[] key, byte[] nonce, Encoding version) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec params = new GCMParameterSpec(128, nonce);
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), params);
        byte[] plaintext = cipher.doFinal(ciphertext);
        if (version == Encoding.AES128GCM) {
            return Arrays.copyOfRange(plaintext, 0, plaintext.length - 1);
        }
        return Arrays.copyOfRange(plaintext, 2, plaintext.length);
    }

    private byte[] buildHeader(byte[] salt, String keyid) {
        byte[] keyIdBytes = keyid == null ? new byte[]{} : Utils.encode(this.getPublicKey(keyid));
        if (keyIdBytes.length > 255) {
            throw new IllegalArgumentException("They keyid is too large.");
        }
        byte[] rs = Utils.toByteArray(4096, 4);
        byte[] idlen = new byte[]{(byte)keyIdBytes.length};
        return Utils.concat(salt, rs, idlen, keyIdBytes);
    }

    protected static byte[] buildInfo(String type, byte[] context) {
        ByteBuffer buffer = ByteBuffer.allocate(19 + type.length() + context.length);
        buffer.put("Content-Encoding: ".getBytes(StandardCharsets.UTF_8), 0, 18);
        buffer.put(type.getBytes(StandardCharsets.UTF_8), 0, type.length());
        buffer.put(new byte[1], 0, 1);
        buffer.put(context, 0, context.length);
        return buffer.array();
    }

    protected static byte[] hkdfExpand(byte[] ikm, byte[] salt, byte[] info, int length) {
        HttpEce.log("salt", salt);
        HttpEce.log("ikm", ikm);
        HttpEce.log("info", info);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, salt, info));
        byte[] okm = new byte[length];
        hkdf.generateBytes(okm, 0, length);
        HttpEce.log("expand", okm);
        return okm;
    }

    public byte[][] extractSecretAndContext(byte[] key, String keyId, ECPublicKey dh, byte[] authSecret) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] secret = null;
        byte[] context = null;
        if (key != null) {
            secret = key;
            if (secret.length != 16) {
                throw new IllegalStateException("An explicit key must be 16 bytes.");
            }
        } else if (dh != null) {
            byte[][] bytes = this.extractDH(keyId, dh);
            secret = bytes[0];
            context = bytes[1];
        } else if (keyId != null) {
            secret = this.keys.get(keyId).getPublic().getEncoded();
        }
        if (secret == null) {
            throw new IllegalStateException("Unable to determine key.");
        }
        if (authSecret != null) {
            secret = HttpEce.hkdfExpand(secret, authSecret, HttpEce.buildInfo("auth", new byte[0]), 32);
        }
        return new byte[][]{secret, context};
    }

    public byte[][] deriveKeyAndNonce(byte[] salt, byte[] key, String keyId, ECPublicKey dh, byte[] authSecret, Encoding version, int mode) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] nonceInfo;
        byte[] keyInfo;
        byte[] secret;
        if (version == Encoding.AESGCM) {
            byte[][] secretAndContext = this.extractSecretAndContext(key, keyId, dh, authSecret);
            secret = secretAndContext[0];
            keyInfo = HttpEce.buildInfo("aesgcm", secretAndContext[1]);
            nonceInfo = HttpEce.buildInfo("nonce", secretAndContext[1]);
        } else if (version == Encoding.AES128GCM) {
            keyInfo = "Content-Encoding: aes128gcm\u0000".getBytes();
            nonceInfo = "Content-Encoding: nonce\u0000".getBytes();
            secret = this.extractSecret(key, keyId, dh, authSecret, mode);
        } else {
            throw new IllegalStateException("Unknown version: " + (Object)((Object)version));
        }
        byte[] hkdf_key = HttpEce.hkdfExpand(secret, salt, keyInfo, 16);
        byte[] hkdf_nonce = HttpEce.hkdfExpand(secret, salt, nonceInfo, 12);
        HttpEce.log("key", hkdf_key);
        HttpEce.log("nonce", hkdf_nonce);
        return new byte[][]{hkdf_key, hkdf_nonce};
    }

    private byte[] extractSecret(byte[] key, String keyId, ECPublicKey dh, byte[] authSecret, int mode) throws InvalidKeyException, NoSuchAlgorithmException {
        if (key != null) {
            if (key.length != 16) {
                throw new IllegalArgumentException("An explicit key must be 16 bytes.");
            }
            return key;
        }
        if (dh == null) {
            KeyPair keyPair = this.keys.get(keyId);
            if (keyPair == null) {
                throw new IllegalArgumentException("No saved key for keyid '" + keyId + "'.");
            }
            return Utils.encode((ECPublicKey)keyPair.getPublic());
        }
        return this.webpushSecret(keyId, dh, authSecret, mode);
    }

    public byte[] webpushSecret(String keyId, ECPublicKey dh, byte[] authSecret, int mode) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] secret;
        ECPublicKey receiverPubKey;
        ECPublicKey remotePubKey;
        ECPublicKey senderPubKey;
        if (mode == 1) {
            senderPubKey = this.getPublicKey(keyId);
            remotePubKey = dh;
            receiverPubKey = dh;
        } else if (mode == 2) {
            senderPubKey = remotePubKey = this.getPublicKey(keyId);
            receiverPubKey = dh;
        } else {
            throw new IllegalArgumentException("Unsupported mode: " + mode);
        }
        HttpEce.log("remote pubkey", Utils.encode(remotePubKey));
        HttpEce.log("sender pubkey", Utils.encode(senderPubKey));
        HttpEce.log("receiver pubkey", Utils.encode(receiverPubKey));
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init((Key)this.getPrivateKey(keyId));
        keyAgreement.doPhase((Key)remotePubKey, true);
        byte[] ikm = secret = keyAgreement.generateSecret();
        byte[] salt = authSecret;
        byte[] info = Utils.concat(WEB_PUSH_INFO.getBytes(), Utils.encode(receiverPubKey), Utils.encode(senderPubKey));
        return HttpEce.hkdfExpand(ikm, salt, info, 32);
    }

    private byte[][] extractDH(String keyid, ECPublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        ECPublicKey senderPubKey = this.getPublicKey(keyid);
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init((Key)this.getPrivateKey(keyid));
        keyAgreement.doPhase((Key)publicKey, true);
        byte[] secret = keyAgreement.generateSecret();
        byte[] context = Utils.concat(this.labels.get(keyid).getBytes(StandardCharsets.UTF_8), new byte[1], HttpEce.lengthPrefix(publicKey), HttpEce.lengthPrefix(senderPubKey));
        return new byte[][]{secret, context};
    }

    private ECPublicKey getPublicKey(String keyid) {
        return (ECPublicKey)this.keys.get(keyid).getPublic();
    }

    private ECPrivateKey getPrivateKey(String keyid) {
        return (ECPrivateKey)this.keys.get(keyid).getPrivate();
    }

    private static byte[] lengthPrefix(ECPublicKey publicKey) {
        byte[] bytes = Utils.encode(publicKey);
        return Utils.concat(HttpEce.intToBytes(bytes.length), bytes);
    }

    private static byte[] intToBytes(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot convert a negative number, " + number + " given.");
        }
        if (number >= 65536) {
            throw new IllegalArgumentException("Cannot convert an integer larger than 65535 to two bytes.");
        }
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(number & 0xFF);
        bytes[0] = (byte)(number >> 8);
        return bytes;
    }

    private static byte[] log(String info, byte[] array) {
        if ("1".equals(System.getenv("ECE_KEYLOG"))) {
            System.out.println(info + " [" + array.length + "]: " + Base64.getUrlEncoder().withoutPadding().encodeToString(array));
        }
        return array;
    }
}

