/*
 * Decompiled with CFR 0.152.
 */
package org.neotech.plugin.rootcoverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neotech.plugin.rootcoverage.RootCoveragePluginExtension;
import org.neotech.plugin.rootcoverage.utilities.GradleExtensionsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a&\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0000\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f*\u00020\u0002H\u0000\u00a8\u0006\r"}, d2={"getBuildVariantFor", "", "Lorg/neotech/plugin/rootcoverage/RootCoveragePluginExtension;", "project", "Lorg/gradle/api/Project;", "getExecutionDataFileTree", "Lorg/gradle/api/file/FileTree;", "includeUnitTestResults", "", "includeConnectedDevicesResults", "includeGradleManagedDevicesResults", "getFileFilterPatterns", "", "plugin"})
public final class JaCoCoConfigurationKt {
    @NotNull
    public static final List<String> getFileFilterPatterns(@NotNull RootCoveragePluginExtension $this$getFileFilterPatterns) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileFilterPatterns, (String)"<this>");
        Object[] objectArray = new String[]{"**/AutoValue_*.*", "**/*databinding", "**/*binders", "**/*layouts", "**/BR.class", "**/R.class", "**/R$*.class", "**/Manifest*.*", "**/BuildConfig.class", "android/**/*.*", "**/*$ViewBinder*.*", "**/*$ViewInjector*.*", "**/Lambda$*.class", "**/Lambda.class", "**/*Lambda.class", "**/*Lambda*.class", "**/*$InjectAdapter.class", "**/*$ModuleAdapter.class", "**/*$ViewInjector*.class"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)$this$getFileFilterPatterns.getExcludes());
    }

    @NotNull
    public static final String getBuildVariantFor(@NotNull RootCoveragePluginExtension $this$getBuildVariantFor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getBuildVariantFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = $this$getBuildVariantFor.getBuildVariantOverrides().get(project.getPath());
        if (string == null) {
            string = $this$getBuildVariantFor.getBuildVariant();
        }
        return string;
    }

    @Nullable
    public static final FileTree getExecutionDataFileTree(@NotNull Project $this$getExecutionDataFileTree, boolean includeUnitTestResults, boolean includeConnectedDevicesResults, boolean includeGradleManagedDevicesResults) {
        FileTree fileTree;
        Intrinsics.checkNotNullParameter((Object)$this$getExecutionDataFileTree, (String)"<this>");
        List buildFolderPatterns = new ArrayList();
        if (includeUnitTestResults) {
            buildFolderPatterns.add("outputs/unit_test_code_coverage/*/*.exec");
        }
        if (includeConnectedDevicesResults) {
            buildFolderPatterns.add("outputs/code_coverage/*/connected/*/coverage.ec");
        }
        if (includeGradleManagedDevicesResults) {
            buildFolderPatterns.add("outputs/managed_device_code_coverage/*/coverage.ec");
        }
        if (buildFolderPatterns.isEmpty()) {
            fileTree = null;
        } else {
            File file = $this$getExecutionDataFileTree.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildDir");
            fileTree = (FileTree)GradleExtensionsKt.fileTree$default($this$getExecutionDataFileTree, file, null, buildFolderPatterns, 2, null);
        }
        return fileTree;
    }
}

