/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.asn1.esf;

import java.util.Enumeration;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1EncodableVector;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Object;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Primitive;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Sequence;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1TaggedObject;
import nl.open.jwtdependency.org.bouncycastle.asn1.DERSequence;
import nl.open.jwtdependency.org.bouncycastle.asn1.DERTaggedObject;
import nl.open.jwtdependency.org.bouncycastle.asn1.DERUTF8String;
import nl.open.jwtdependency.org.bouncycastle.asn1.x500.DirectoryString;

public class SignerLocation
extends ASN1Object {
    private DERUTF8String countryName;
    private DERUTF8String localityName;
    private ASN1Sequence postalAddress;

    private SignerLocation(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    DirectoryString directoryString = DirectoryString.getInstance(aSN1TaggedObject, true);
                    this.countryName = new DERUTF8String(directoryString.getString());
                    continue block5;
                }
                case 1: {
                    DirectoryString directoryString = DirectoryString.getInstance(aSN1TaggedObject, true);
                    this.localityName = new DERUTF8String(directoryString.getString());
                    continue block5;
                }
                case 2: {
                    this.postalAddress = aSN1TaggedObject.isExplicit() ? ASN1Sequence.getInstance(aSN1TaggedObject, true) : ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    if (this.postalAddress == null || this.postalAddress.size() <= 6) continue block5;
                    throw new IllegalArgumentException("postal address must contain less than 6 strings");
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public SignerLocation(DERUTF8String dERUTF8String, DERUTF8String dERUTF8String2, ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence != null && aSN1Sequence.size() > 6) {
            throw new IllegalArgumentException("postal address must contain less than 6 strings");
        }
        if (dERUTF8String != null) {
            this.countryName = DERUTF8String.getInstance(dERUTF8String.toASN1Primitive());
        }
        if (dERUTF8String2 != null) {
            this.localityName = DERUTF8String.getInstance(dERUTF8String2.toASN1Primitive());
        }
        if (aSN1Sequence != null) {
            this.postalAddress = ASN1Sequence.getInstance(aSN1Sequence.toASN1Primitive());
        }
    }

    public static SignerLocation getInstance(Object object) {
        if (object == null || object instanceof SignerLocation) {
            return (SignerLocation)object;
        }
        return new SignerLocation(ASN1Sequence.getInstance(object));
    }

    public DERUTF8String getCountryName() {
        return this.countryName;
    }

    public DERUTF8String getLocalityName() {
        return this.localityName;
    }

    public ASN1Sequence getPostalAddress() {
        return this.postalAddress;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.countryName != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.countryName));
        }
        if (this.localityName != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.localityName));
        }
        if (this.postalAddress != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.postalAddress));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

