/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import nl.open.jwtdependency.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import nl.open.jwtdependency.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import nl.open.jwtdependency.org.bouncycastle.crypto.KeyGenerationParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECDomainParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECConstants;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECMultiplier;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECPoint;
import nl.open.jwtdependency.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import nl.open.jwtdependency.org.bouncycastle.math.ec.WNafUtil;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

