/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.crypto.tls;

import nl.open.jwtdependency.org.bouncycastle.crypto.AsymmetricBlockCipher;
import nl.open.jwtdependency.org.bouncycastle.crypto.CipherParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.CryptoException;
import nl.open.jwtdependency.org.bouncycastle.crypto.Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.Signer;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.NullDigest;
import nl.open.jwtdependency.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import nl.open.jwtdependency.org.bouncycastle.crypto.engines.RSABlindedEngine;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ParametersWithRandom;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.RSAKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.signers.GenericSigner;
import nl.open.jwtdependency.org.bouncycastle.crypto.signers.RSADigestSigner;
import nl.open.jwtdependency.org.bouncycastle.crypto.tls.AbstractTlsSigner;
import nl.open.jwtdependency.org.bouncycastle.crypto.tls.CombinedHash;
import nl.open.jwtdependency.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import nl.open.jwtdependency.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        signer.update(byArray, 0, byArray.length);
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, false, asymmetricKeyParameter);
        signer.update(byArray2, 0, byArray2.length);
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, false, asymmetricKeyParameter);
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, boolean bl, boolean bl2, CipherParameters cipherParameters) {
        if (signatureAndHashAlgorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Digest digest = bl ? new NullDigest() : (signatureAndHashAlgorithm == null ? new CombinedHash() : TlsUtils.createHash(signatureAndHashAlgorithm.getHash()));
        Signer signer = signatureAndHashAlgorithm != null ? new RSADigestSigner(digest, TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash())) : new GenericSigner(this.createRSAImpl(), digest);
        signer.init(bl2, cipherParameters);
        return signer;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

