/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.crypto.util;

import java.io.IOException;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Encodable;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Integer;
import nl.open.jwtdependency.org.bouncycastle.asn1.DERNull;
import nl.open.jwtdependency.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import nl.open.jwtdependency.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import nl.open.jwtdependency.org.bouncycastle.asn1.sec.ECPrivateKey;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.DSAParameter;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.X962Parameters;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.X9ECParameters;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.DSAParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECDomainParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.RSAKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyInfoFactory {
    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(rSAPrivateCrtKeyParameters.getModulus(), rSAPrivateCrtKeyParameters.getPublicExponent(), rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ(), rSAPrivateCrtKeyParameters.getDP(), rSAPrivateCrtKeyParameters.getDQ(), rSAPrivateCrtKeyParameters.getQInv()));
        }
        if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPrivateKeyParameters.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG())), new ASN1Integer(dSAPrivateKeyParameters.getX()));
        }
        if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            int n;
            X962Parameters x962Parameters;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
            ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
                n = eCPrivateKeyParameters.getD().bitLength();
            } else if (eCDomainParameters instanceof ECNamedDomainParameters) {
                x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
                n = eCDomainParameters.getN().bitLength();
            } else {
                X9ECParameters x9ECParameters = new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
                n = eCDomainParameters.getN().bitLength();
            }
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKey(n, eCPrivateKeyParameters.getD(), (ASN1Encodable)x962Parameters));
        }
        throw new IOException("key parameters not recognised.");
    }
}

