/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Encodable;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Integer;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Primitive;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1Sequence;
import nl.open.jwtdependency.org.bouncycastle.asn1.DERSequence;
import nl.open.jwtdependency.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.crypto.CipherParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.DSA;
import nl.open.jwtdependency.org.bouncycastle.crypto.Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.NullDigest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA1Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA224Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA256Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA384Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA3Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA512Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ParametersWithRandom;
import nl.open.jwtdependency.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected DSASigner(Digest digest, DSA dSA) {
        this.digest = digest;
        this.signer = dSA;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (publicKey instanceof DSAKey) {
            asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] byArray = publicKey.getEncoded();
                publicKey = new BCDSAPublicKey(SubjectPublicKeyInfo.getInstance(byArray));
                if (!(publicKey instanceof DSAKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, asymmetricKeyParameter);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters = DSAUtil.generatePrivateKeyParameter(privateKey);
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        this.digest.reset();
        this.signer.init(true, cipherParameters);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.signer.generateSignature(byArray);
            return this.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger[] bigIntegerArray;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            bigIntegerArray = this.derDecode(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Integer[]{new ASN1Integer(bigInteger), new ASN1Integer(bigInteger2)};
        return new DERSequence(aSN1EncodableArray).getEncoded("DER");
    }

    private BigInteger[] derDecode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        return new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
    }

    public static class detDSA
    extends DSASigner {
        public detDSA() {
            super(new SHA1Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA1Digest())));
        }
    }

    public static class detDSA224
    extends DSASigner {
        public detDSA224() {
            super(new SHA224Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA224Digest())));
        }
    }

    public static class detDSA256
    extends DSASigner {
        public detDSA256() {
            super(new SHA256Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA256Digest())));
        }
    }

    public static class detDSA384
    extends DSASigner {
        public detDSA384() {
            super(new SHA384Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA384Digest())));
        }
    }

    public static class detDSA512
    extends DSASigner {
        public detDSA512() {
            super(new SHA512Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA512Digest())));
        }
    }

    public static class detDSASha3_224
    extends DSASigner {
        public detDSASha3_224() {
            super(new SHA3Digest(224), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA3Digest(224))));
        }
    }

    public static class detDSASha3_256
    extends DSASigner {
        public detDSASha3_256() {
            super(new SHA3Digest(256), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA3Digest(256))));
        }
    }

    public static class detDSASha3_384
    extends DSASigner {
        public detDSASha3_384() {
            super(new SHA3Digest(384), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA3Digest(384))));
        }
    }

    public static class detDSASha3_512
    extends DSASigner {
        public detDSASha3_512() {
            super(new SHA3Digest(512), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(new SHA3Digest(512))));
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            super(new SHA224Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            super(new SHA256Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            super(new SHA384Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            super(new SHA512Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_224
    extends DSASigner {
        public dsaSha3_224() {
            super(new SHA3Digest(224), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_256
    extends DSASigner {
        public dsaSha3_256() {
            super(new SHA3Digest(256), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_384
    extends DSASigner {
        public dsaSha3_384() {
            super(new SHA3Digest(384), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_512
    extends DSASigner {
        public dsaSha3_512() {
            super(new SHA3Digest(512), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            super(new NullDigest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            super(new SHA1Digest(), new nl.open.jwtdependency.org.bouncycastle.crypto.signers.DSASigner());
        }
    }
}

