/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dstu;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import nl.open.jwtdependency.org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import nl.open.jwtdependency.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import nl.open.jwtdependency.org.bouncycastle.crypto.generators.DSTU4145KeyPairGenerator;
import nl.open.jwtdependency.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECDomainParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PrivateKey;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import nl.open.jwtdependency.org.bouncycastle.jce.provider.BouncyCastleProvider;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECCurve;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECPoint;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new DSTU4145KeyPairGenerator();
    String algorithm = "DSTU4145";
    ECKeyGenerationParameters param;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSTU4145");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.random = secureRandom;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof java.security.spec.ECParameterSpec) {
            java.security.spec.ECParameterSpec eCParameterSpec = (java.security.spec.ECParameterSpec)algorithmParameterSpec;
            this.ecParams = algorithmParameterSpec;
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec || algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            String string = algorithmParameterSpec instanceof ECGenParameterSpec ? ((ECGenParameterSpec)algorithmParameterSpec).getName() : ((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName();
            ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID(new ASN1ObjectIdentifier(string));
            if (eCDomainParameters == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
            }
            this.ecParams = new ECNamedCurveSpec(string, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
            java.security.spec.ECParameterSpec eCParameterSpec = (java.security.spec.ECParameterSpec)this.ecParams;
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            ECParameterSpec eCParameterSpec = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = algorithmParameterSpec;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            if (algorithmParameterSpec == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + algorithmParameterSpec.getClass().getName());
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("DSTU Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        if (this.ecParams instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            BCDSTU4145PublicKey bCDSTU4145PublicKey = new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
            return new KeyPair(bCDSTU4145PublicKey, new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters, bCDSTU4145PublicKey, eCParameterSpec));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters), new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters));
        }
        java.security.spec.ECParameterSpec eCParameterSpec = (java.security.spec.ECParameterSpec)this.ecParams;
        BCDSTU4145PublicKey bCDSTU4145PublicKey = new BCDSTU4145PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec);
        return new KeyPair(bCDSTU4145PublicKey, new BCDSTU4145PrivateKey(this.algorithm, eCPrivateKeyParameters, bCDSTU4145PublicKey, eCParameterSpec));
    }
}

