/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.util;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import nl.open.jwtdependency.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.X962Parameters;
import nl.open.jwtdependency.org.bouncycastle.asn1.x9.X9ECParameters;
import nl.open.jwtdependency.org.bouncycastle.crypto.ec.CustomNamedCurves;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECNamedCurveSpec;
import nl.open.jwtdependency.org.bouncycastle.jce.spec.ECParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECAlgorithms;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECCurve;
import nl.open.jwtdependency.org.bouncycastle.math.ec.ECPoint;
import nl.open.jwtdependency.org.bouncycastle.math.field.FiniteField;
import nl.open.jwtdependency.org.bouncycastle.math.field.Polynomial;
import nl.open.jwtdependency.org.bouncycastle.math.field.PolynomialExtensionField;
import nl.open.jwtdependency.org.bouncycastle.util.Arrays;

public class EC5Util {
    private static Map customCurves = new HashMap();

    public static ECCurve getCurve(ProviderConfiguration providerConfiguration, X962Parameters x962Parameters) {
        ECCurve eCCurve;
        if (x962Parameters.isNamedCurve()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
            eCCurve = x9ECParameters.getCurve();
        } else if (x962Parameters.isImplicitlyCA()) {
            eCCurve = providerConfiguration.getEcImplicitlyCa().getCurve();
        } else {
            X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
            eCCurve = x9ECParameters.getCurve();
        }
        return eCCurve;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X962Parameters x962Parameters, ECCurve eCCurve) {
        java.security.spec.ECParameterSpec eCParameterSpec;
        if (x962Parameters.isNamedCurve()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
            X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, x9ECParameters.getSeed());
            eCParameterSpec = new ECNamedCurveSpec(ECUtil.getCurveName(aSN1ObjectIdentifier), ellipticCurve, new java.security.spec.ECPoint(x9ECParameters.getG().getAffineXCoord().toBigInteger(), x9ECParameters.getG().getAffineYCoord().toBigInteger()), x9ECParameters.getN(), x9ECParameters.getH());
        } else if (x962Parameters.isImplicitlyCA()) {
            eCParameterSpec = null;
        } else {
            X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, x9ECParameters.getSeed());
            eCParameterSpec = x9ECParameters.getH() != null ? new java.security.spec.ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(x9ECParameters.getG().getAffineXCoord().toBigInteger(), x9ECParameters.getG().getAffineYCoord().toBigInteger()), x9ECParameters.getN(), x9ECParameters.getH().intValue()) : new java.security.spec.ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(x9ECParameters.getG().getAffineXCoord().toBigInteger(), x9ECParameters.getG().getAffineYCoord().toBigInteger()), x9ECParameters.getN(), 1);
        }
        return eCParameterSpec;
    }

    public static java.security.spec.ECParameterSpec convertToSpec(X9ECParameters x9ECParameters) {
        return new java.security.spec.ECParameterSpec(EC5Util.convertCurve(x9ECParameters.getCurve(), null), new java.security.spec.ECPoint(x9ECParameters.getG().getAffineXCoord().toBigInteger(), x9ECParameters.getG().getAffineYCoord().toBigInteger()), x9ECParameters.getN(), x9ECParameters.getH().intValue());
    }

    public static EllipticCurve convertCurve(ECCurve eCCurve, byte[] byArray) {
        ECField eCField = EC5Util.convertField(eCCurve.getField());
        BigInteger bigInteger = eCCurve.getA().toBigInteger();
        BigInteger bigInteger2 = eCCurve.getB().toBigInteger();
        return new EllipticCurve(eCField, bigInteger, bigInteger2, null);
    }

    public static ECCurve convertCurve(EllipticCurve ellipticCurve) {
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger = ellipticCurve.getA();
        BigInteger bigInteger2 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            ECCurve.Fp fp = new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger, bigInteger2);
            if (customCurves.containsKey(fp)) {
                return (ECCurve)customCurves.get(fp);
            }
            return fp;
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
        int n = eCFieldF2m.getM();
        int[] nArray = ECUtil.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(n, nArray[0], nArray[1], nArray[2], bigInteger, bigInteger2);
    }

    public static ECField convertField(FiniteField finiteField) {
        if (ECAlgorithms.isFpField(finiteField)) {
            return new ECFieldFp(finiteField.getCharacteristic());
        }
        Polynomial polynomial = ((PolynomialExtensionField)finiteField).getMinimalPolynomial();
        int[] nArray = polynomial.getExponentsPresent();
        int[] nArray2 = Arrays.reverse(Arrays.copyOfRange(nArray, 1, nArray.length - 1));
        return new ECFieldF2m(polynomial.getDegree(), nArray2);
    }

    public static java.security.spec.ECParameterSpec convertSpec(EllipticCurve ellipticCurve, ECParameterSpec eCParameterSpec) {
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            return new ECNamedCurveSpec(((ECNamedCurveParameterSpec)eCParameterSpec).getName(), ellipticCurve, new java.security.spec.ECPoint(eCParameterSpec.getG().getAffineXCoord().toBigInteger(), eCParameterSpec.getG().getAffineYCoord().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH());
        }
        return new java.security.spec.ECParameterSpec(ellipticCurve, new java.security.spec.ECPoint(eCParameterSpec.getG().getAffineXCoord().toBigInteger(), eCParameterSpec.getG().getAffineYCoord().toBigInteger()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
    }

    public static ECParameterSpec convertSpec(java.security.spec.ECParameterSpec eCParameterSpec, boolean bl) {
        ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
        return new ECParameterSpec(eCCurve, EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), bl), eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()), eCParameterSpec.getCurve().getSeed());
    }

    public static ECPoint convertPoint(java.security.spec.ECParameterSpec eCParameterSpec, java.security.spec.ECPoint eCPoint, boolean bl) {
        return EC5Util.convertPoint(EC5Util.convertCurve(eCParameterSpec.getCurve()), eCPoint, bl);
    }

    public static ECPoint convertPoint(ECCurve eCCurve, java.security.spec.ECPoint eCPoint, boolean bl) {
        return eCCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
    }

    static {
        Enumeration enumeration = CustomNamedCurves.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
            if (x9ECParameters == null) continue;
            customCurves.put(x9ECParameters.getCurve(), CustomNamedCurves.getByName(string).getCurve());
        }
    }
}

