/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import nl.open.jwtdependency.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.crypto.BlockCipher;
import nl.open.jwtdependency.org.bouncycastle.crypto.CipherKeyGenerator;
import nl.open.jwtdependency.org.bouncycastle.crypto.engines.SEEDEngine;
import nl.open.jwtdependency.org.bouncycastle.crypto.engines.SEEDWrapEngine;
import nl.open.jwtdependency.org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import nl.open.jwtdependency.org.bouncycastle.crypto.macs.CMac;
import nl.open.jwtdependency.org.bouncycastle.crypto.macs.GMac;
import nl.open.jwtdependency.org.bouncycastle.crypto.modes.CBCBlockCipher;
import nl.open.jwtdependency.org.bouncycastle.crypto.modes.GCMBlockCipher;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import nl.open.jwtdependency.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class SEED {
    private SEED() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = this.createParametersInstance("SEED");
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new SEEDEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new SEEDEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SEEDEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SEED.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("AlgorithmParameters.SEED", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("AlgorithmParameterGenerator.SEED", PREFIX + "$AlgParamGen");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            configurableProvider.addAlgorithm("Cipher.SEED", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher.SEEDWRAP", PREFIX + "$Wrap");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWRAP");
            configurableProvider.addAlgorithm("Alg.Alias.Cipher.SEEDKW", "SEEDWRAP");
            configurableProvider.addAlgorithm("KeyGenerator.SEED", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("KeyGenerator", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, PREFIX + "$KeyGen");
            this.addCMacAlgorithm(configurableProvider, "SEED", PREFIX + "$CMAC", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "SEED", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SEED", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new nl.open.jwtdependency.org.bouncycastle.crypto.macs.Poly1305(new SEEDEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SEED", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(new SEEDWrapEngine());
        }
    }
}

