/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.pqc.jcajce.provider.gmss;

import java.security.PublicKey;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import nl.open.jwtdependency.org.bouncycastle.crypto.CipherParameters;
import nl.open.jwtdependency.org.bouncycastle.pqc.asn1.GMSSPublicKey;
import nl.open.jwtdependency.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.pqc.asn1.ParSet;
import nl.open.jwtdependency.org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import nl.open.jwtdependency.org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import nl.open.jwtdependency.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import nl.open.jwtdependency.org.bouncycastle.util.encoders.Hex;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] byArray, GMSSParameters gMSSParameters) {
        this.gmssParameterSet = gMSSParameters;
        this.publicKeyBytes = byArray;
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters gMSSPublicKeyParameters) {
        this(gMSSPublicKeyParameters.getPublicKey(), gMSSPublicKeyParameters.getParameters());
    }

    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String string = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes)) + "\n" + "Height of Trees: \n";
        for (int i = 0; i < this.gmssParameterSet.getHeightOfTrees().length; ++i) {
            string = string + "Layer " + i + " : " + this.gmssParameterSet.getHeightOfTrees()[i] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i] + " K: " + this.gmssParameterSet.getK()[i] + "\n";
        }
        return string;
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    public String getFormat() {
        return "X.509";
    }
}

