/*
 * Decompiled with CFR 0.152.
 */
package nl.open.jwtdependency.org.bouncycastle.pqc.jcajce.provider.mceliece;

import nl.open.jwtdependency.org.bouncycastle.asn1.DERNull;
import nl.open.jwtdependency.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import nl.open.jwtdependency.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import nl.open.jwtdependency.org.bouncycastle.crypto.Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA1Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA224Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA256Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA384Digest;
import nl.open.jwtdependency.org.bouncycastle.crypto.digests.SHA512Digest;

class Utils {
    Utils() {
    }

    static AlgorithmIdentifier getDigAlgId(String string) {
        if (string.equals("SHA-1")) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        }
        if (string.equals("SHA-224")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE);
        }
        if (string.equals("SHA-256")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        }
        if (string.equals("SHA-384")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE);
        }
        if (string.equals("SHA-512")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE);
        }
        throw new IllegalArgumentException("unrecognised digest algorithm: " + string);
    }

    static Digest getDigest(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            return new SHA1Digest();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            return new SHA224Digest();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            return new SHA384Digest();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        throw new IllegalArgumentException("unrecognised OID in digest algorithm identifier: " + algorithmIdentifier.getAlgorithm());
    }
}

