/*
 * Decompiled with CFR 0.152.
 */
package nl.openweb.jcr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJcrRepository
implements Repository,
AutoCloseable {
    private final RepositoryImpl repository;
    private final File repositoryFolder;
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryJcrRepository.class);

    public InMemoryJcrRepository() throws RepositoryException, URISyntaxException, IOException {
        InputStream configFile = InMemoryJcrRepository.class.getClassLoader().getResourceAsStream("configuration.xml");
        this.repositoryFolder = Files.createTempDirectory("repository-", new FileAttribute[0]).toFile();
        RepositoryConfig config = RepositoryConfig.create((InputStream)configFile, (String)this.repositoryFolder.getAbsolutePath());
        this.repository = RepositoryImpl.create((RepositoryConfig)config);
    }

    public void shutdown() throws IOException {
        this.repository.shutdown();
        FileUtils.deleteDirectory((File)this.repositoryFolder);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(credentials, workspaceName);
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public Value getDescriptorValue(String key) {
        return this.repository.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.repository.getDescriptorValues(key);
    }

    public boolean isStandardDescriptor(String key) {
        return this.repository.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repository.isSingleValueDescriptor(key);
    }

    public Session login() throws RepositoryException {
        return this.repository.login();
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.repository.login(credentials);
    }

    public Session login(String workspace) throws RepositoryException {
        return this.repository.login(workspace);
    }

    @Override
    public void close() {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            LOG.warn("Failed to removed temporary repository folder.", (Throwable)e);
        }
    }
}

