/*
 * Decompiled with CFR 0.152.
 */
package nl.openweb.jcr.utils;

import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class NodeTypeDefUtils {
    private NodeTypeDefUtils() {
    }

    public static void createNodeType(Session session, String nodeType) throws RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        if (!nodeTypeManager.hasNodeType(nodeType)) {
            NodeTypeDefUtils.registerNodeOrMixin(session, nodeType, "nt:unstructured", false);
        }
    }

    public static void createNodeType(Session session, String nodeType, String superType) throws RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        NodeTypeDefUtils.createNodeType(session, superType);
        if (!nodeTypeManager.hasNodeType(nodeType)) {
            NodeTypeDefUtils.registerNodeOrMixin(session, nodeType, superType, false);
        }
    }

    public static void createMixin(Session session, String mixinType) throws RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        if (!nodeTypeManager.hasNodeType(mixinType)) {
            NodeTypeDefUtils.registerNodeOrMixin(session, mixinType, "nt:unstructured", true);
        }
    }

    public static void createMixin(Session session, String mixinType, String superType) throws RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        NodeTypeDefUtils.createMixin(session, superType);
        if (!nodeTypeManager.hasNodeType(mixinType)) {
            NodeTypeDefUtils.registerNodeOrMixin(session, mixinType, superType, true);
        }
    }

    public static String getOrRegisterNamespace(Session session, String name) throws RepositoryException {
        String uri = null;
        if (name.indexOf(58) > -1) {
            String prefix = name.substring(0, name.indexOf(58));
            NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
            try {
                uri = namespaceRegistry.getURI(prefix);
            }
            catch (RepositoryException e) {
                uri = "https://www.openweb.nl/" + prefix + "/nt/1.0";
                namespaceRegistry.registerNamespace(prefix, uri);
            }
        }
        return uri;
    }

    private static void registerNodeOrMixin(Session session, String nodeType, String superType, boolean isMixin) throws RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        String uri = NodeTypeDefUtils.getOrRegisterNamespace(session, nodeType);
        NameFactory nameFactory = NameFactoryImpl.getInstance();
        Name name = nameFactory.create(uri, NodeTypeDefUtils.getLocalName(nodeType));
        ValueFactory valueFactory = session.getValueFactory();
        String namespace = NodeTypeDefUtils.getOrRegisterNamespace(session, superType);
        Name[] supertypes = new Name[]{nameFactory.create(namespace, NodeTypeDefUtils.getLocalName(superType))};
        QNodeTypeDefinitionImpl ntd = new QNodeTypeDefinitionImpl(name, supertypes, new Name[0], isMixin, false, true, true, null, new QPropertyDefinition[0], new QNodeDefinition[0]);
        NodeTypeDefinitionImpl nodeTypeDefinition = new NodeTypeDefinitionImpl((QNodeTypeDefinition)ntd, (NamePathResolver)((SessionImpl)session), valueFactory);
        nodeTypeManager.registerNodeType((NodeTypeDefinition)nodeTypeDefinition, false);
    }

    private static String getLocalName(String nodeType) {
        return nodeType.substring(nodeType.indexOf(58) + 1);
    }
}

