/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest;

import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.decoder.RESTStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Util {
    public static final String QUIET_ON_NOT_FOUND_PARAM = "quietOnNotFound=";
    public static final boolean DEFAULT_QUIET_ON_NOT_FOUND = true;

    public static List<RESTStyle> searchStyles(GeoServerRESTReader reader, String stylename) {
        ArrayList<RESTStyle> styles = new ArrayList<RESTStyle>();
        RESTStyle style = reader.getStyle(stylename);
        if (style != null && (style.getWorkspace() == null || style.getWorkspace().isEmpty())) {
            styles.add(style);
        }
        for (String workspace : reader.getWorkspaceNames()) {
            style = reader.getStyle(workspace, stylename);
            if (style == null) continue;
            styles.add(style);
        }
        return styles;
    }

    public static String appendQuietOnNotFound(boolean quietOnNotFound, String url) {
        boolean contains = url.contains("?");
        String composed = url + (contains ? "&" : "?") + QUIET_ON_NOT_FOUND_PARAM + quietOnNotFound;
        return composed;
    }

    public static <T> List<T> safeList(List<T> list) {
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public static <T> Collection<T> safeCollection(Collection<T> collection) {
        return collection == null ? Collections.EMPTY_SET : collection;
    }

    public static <TK, TV> Map<TK, TV> safeMap(Map<TK, TV> map) {
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public static char getParameterSeparator(String url) {
        char parameterSeparator = '?';
        if (url.contains("?")) {
            parameterSeparator = '&';
        }
        return parameterSeparator;
    }

    public static char getParameterSeparator(StringBuilder url) {
        char parameterSeparator = '?';
        if (url.indexOf("?") != -1) {
            parameterSeparator = '&';
        }
        return parameterSeparator;
    }

    public static boolean appendParameter(StringBuilder url, String parameterName, String parameterValue) {
        boolean result = false;
        if (parameterName != null && !parameterName.isEmpty() && parameterValue != null && !parameterValue.isEmpty()) {
            char parameterSeparator = Util.getParameterSeparator(url);
            url.append(parameterSeparator).append(parameterName.trim()).append('=').append(parameterValue.trim());
        }
        return result;
    }
}

