/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RESTNamespaceList
implements Iterable<RESTShortNamespace> {
    private final List<Element> nsList;

    public static RESTNamespaceList build(String response) {
        if (response == null) {
            return null;
        }
        Element elem = JDOMBuilder.buildElement(response);
        if (elem != null) {
            return new RESTNamespaceList(elem);
        }
        return null;
    }

    protected RESTNamespaceList(Element wslistroot) {
        ArrayList<Element> tmpList = new ArrayList<Element>();
        for (Element wselem : wslistroot.getChildren("namespace")) {
            tmpList.add(wselem);
        }
        this.nsList = Collections.unmodifiableList(tmpList);
    }

    public int size() {
        return this.nsList.size();
    }

    public boolean isEmpty() {
        return this.nsList.isEmpty();
    }

    public RESTShortNamespace get(int index) {
        return new RESTShortNamespace(this.nsList.get(index));
    }

    @Override
    public Iterator<RESTShortNamespace> iterator() {
        return new RESTNSListIterator(this.nsList);
    }

    public static class RESTShortNamespace {
        private final Element nsElem;

        public RESTShortNamespace(Element elem) {
            this.nsElem = elem;
        }

        public String getName() {
            return this.nsElem.getChildText("name");
        }
    }

    private static class RESTNSListIterator
    implements Iterator<RESTShortNamespace> {
        private final Iterator<Element> iter;

        public RESTNSListIterator(List<Element> orig) {
            this.iter = orig.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RESTShortNamespace next() {
            return new RESTShortNamespace(this.iter.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

