/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RESTStructuredCoverageIndexSchema
implements Iterable<RESTStructuredCoverageIndexAttribute> {
    private final List<RESTStructuredCoverageIndexAttribute> attributeList;

    protected RESTStructuredCoverageIndexSchema(Element schema) {
        if (!schema.getName().equals("Schema")) {
            throw new IllegalStateException("Root element should be Schema");
        }
        Element attributes = schema.getChild("attributes");
        if (attributes == null) {
            throw new IllegalStateException("Root element should be Schema");
        }
        ArrayList<RESTStructuredCoverageIndexAttribute> tmpList = new ArrayList<RESTStructuredCoverageIndexAttribute>();
        for (Element el : attributes.getChildren()) {
            tmpList.add(new RESTStructuredCoverageIndexAttribute(el));
        }
        this.attributeList = Collections.unmodifiableList(tmpList);
    }

    public static RESTStructuredCoverageIndexSchema build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTStructuredCoverageIndexSchema(pb);
        }
        return null;
    }

    public int size() {
        return this.attributeList.size();
    }

    public boolean isEmpty() {
        return this.attributeList.isEmpty();
    }

    public RESTStructuredCoverageIndexAttribute get(int index) {
        return this.attributeList.get(index);
    }

    @Override
    public Iterator<RESTStructuredCoverageIndexAttribute> iterator() {
        return this.attributeList.iterator();
    }

    public static class RESTStructuredCoverageIndexAttribute {
        protected final Element attribute;

        public RESTStructuredCoverageIndexAttribute(Element elem) {
            this.attribute = elem;
        }

        public String getName() {
            return this.attribute.getChildTextTrim("name");
        }

        public String getMinOccurs() {
            return this.attribute.getChildTextTrim("minOccurs");
        }

        public String getMaxOccurs() {
            return this.attribute.getChildTextTrim("maxOccurs");
        }

        public String getNillable() {
            return this.attribute.getChildTextTrim("nillable");
        }

        public String getBinding() {
            return this.attribute.getChildTextTrim("binding");
        }

        public String toString() {
            return "RESTStructuredCoverageGranule [getName()=" + this.getName() + ", getMinOccurs()=" + this.getMinOccurs() + ", getMaxOccurs()=" + this.getMaxOccurs() + ", getNillable()=" + this.getNillable() + ", getBinding()=" + this.getBinding() + "]";
        }
    }
}

