/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.identifier;

import it.geosolutions.geoserver.rest.encoder.identifier.IdentifierInfo;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSIdentifierInfoEncoder
extends XmlElement {
    public static Filter getFilterByHref(String authority) {
        return new filterByAuthority(authority);
    }

    public GSIdentifierInfoEncoder() {
        super("Identifier");
    }

    public GSIdentifierInfoEncoder(String authority, String identifier) {
        super("Identifier");
        this.setup(authority, identifier);
    }

    protected void setup(String authority, String identifier) {
        this.set(IdentifierInfo.authority.name(), authority);
        this.set(IdentifierInfo.identifier.name(), identifier);
    }

    protected void setMember(IdentifierInfo type, String value) {
        this.set(type.toString(), value);
    }

    public void setAuthority(String authority) {
        this.setMember(IdentifierInfo.authority, authority);
    }

    public void setIdentifier(String identifier) {
        this.setMember(IdentifierInfo.identifier, identifier);
    }

    protected boolean delMember(IdentifierInfo type) {
        return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(type.toString()));
    }

    public boolean delAuthority() {
        return this.delMember(IdentifierInfo.authority);
    }

    public boolean delIdentifier() {
        return this.delMember(IdentifierInfo.identifier);
    }

    protected String getMember(IdentifierInfo type) {
        Element el = this.getRoot().getChild(type.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public String getAuthority() {
        return this.getMember(IdentifierInfo.authority);
    }

    public String getIdentifier() {
        return this.getMember(IdentifierInfo.identifier);
    }

    private static class filterByAuthority
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByAuthority(String authority) {
            this.key = authority;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild(IdentifierInfo.authority.toString());
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

