/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadata.virtualtable;

import it.geosolutions.geoserver.rest.encoder.metadata.virtualtable.VTGeometryEncoder;
import it.geosolutions.geoserver.rest.encoder.metadata.virtualtable.VTParameterEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSVirtualTableEncoder
extends XmlElement {
    public static final String NAME = "name";
    public static final String SQL = "sql";
    public static final String KEYCOLUMN = "keyColumn";

    public GSVirtualTableEncoder() {
        super("virtualTable");
    }

    public GSVirtualTableEncoder(String name, String sql, List<String> keyColumns, List<VTGeometryEncoder> geomEncList, List<VTParameterEncoder> paramEncList) {
        super("virtualTable");
        this.setup(name, sql, keyColumns, geomEncList, paramEncList);
    }

    protected void setup(String name, String sql, List<String> keyColumns, List<VTGeometryEncoder> geomEncList, List<VTParameterEncoder> paramEncList) {
        this.setName(name);
        this.setSql(sql);
        if (keyColumns != null) {
            for (String pk : keyColumns) {
                this.addKeyColumn(pk);
            }
        }
        if (geomEncList != null) {
            for (VTGeometryEncoder geomEnc : geomEncList) {
                this.addVirtualTableGeometry(geomEnc);
            }
        }
        if (paramEncList != null) {
            for (VTParameterEncoder paramEnc : paramEncList) {
                this.addVirtualTableParameter(paramEnc);
            }
        }
    }

    protected void addName(String name) {
        this.add(NAME, name);
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getName() {
        Element nameNode = ElementUtils.contains(this.getRoot(), NAME, 1);
        if (nameNode != null) {
            return nameNode.getText();
        }
        return null;
    }

    protected void addSql(String sql) {
        this.add(SQL, sql);
    }

    public void setSql(String sql) {
        this.set(SQL, sql);
    }

    public String getSql() {
        Element sqlNode = ElementUtils.contains(this.getRoot(), SQL, 1);
        if (sqlNode != null) {
            return sqlNode.getText();
        }
        return null;
    }

    public void addKeyColumn(String keycolumn) {
        Element el = new Element(KEYCOLUMN);
        el.setText(keycolumn);
        this.getRoot().addContent((Content)el);
    }

    public boolean delKeyColumn(final String keycolumn) {
        Element el = new Element(KEYCOLUMN);
        el.setText(keycolumn);
        return this.getRoot().removeContent(new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                return ((Element)obj).getText().equals(keycolumn);
            }
        }).size() != 0;
    }

    public void addVirtualTableGeometry(VTGeometryEncoder geomEnc) {
        this.getRoot().addContent((Content)geomEnc.getRoot());
    }

    public void addVirtualTableGeometry(String name, String geometryType, String srid) {
        VTGeometryEncoder gEnc = new VTGeometryEncoder();
        gEnc.setup(name, geometryType, srid);
        this.getRoot().addContent((Content)gEnc.getRoot());
    }

    public boolean delVirtualTableGeometry(String name) {
        return this.getRoot().removeContent(VTGeometryEncoder.getFilterByName(name)).size() != 0;
    }

    public void addVirtualTableParameter(VTParameterEncoder paramEnc) {
        this.getRoot().addContent((Content)paramEnc.getRoot());
    }

    public void addVirtualTableParameter(String name, String defaultValue, String regexpValidator) {
        VTParameterEncoder pEnc = new VTParameterEncoder();
        pEnc.setup(name, defaultValue, regexpValidator);
        this.getRoot().addContent((Content)pEnc.getRoot());
    }

    public boolean delVirtualTableParameter(String name) {
        return this.getRoot().removeContent(VTParameterEncoder.getFilterByName(name)).size() != 0;
    }

    public boolean validate() throws IllegalStateException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

