/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.shapeprocessing.data.shapes;

import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.pdok.shapeprocessing.data.shapes.FeatureToTable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FeatureToTableLoader {
    private static final String FEATURETOTABLE = "featureToTable";

    public static FeatureToTable LoadFeatureToTableFromJSON(Path featuresToTablesPath) throws Exception {
        FeatureToTable featuresToTables = new FeatureToTable();
        JSONObject featuresToTableJson = FeatureToTableLoader.getJSONObject(featuresToTablesPath);
        if (featuresToTableJson == null) {
            return featuresToTables;
        }
        try {
            JSONObject featuresToTablesData = (JSONObject)featuresToTableJson.get((Object)FEATURETOTABLE);
            Set sources = featuresToTablesData.keySet();
            for (String source : sources) {
                Object list = featuresToTablesData.get((Object)source);
                List tables = (List)list;
                featuresToTables.getFeatureToTables().put(source, tables);
            }
            for (String key : featuresToTableJson.keySet()) {
                if (key.equals(FEATURETOTABLE)) continue;
                Map<String, String> table = FeatureToTableLoader.simpleJsonMapToJavaMap((JSONObject)featuresToTableJson.get((Object)key));
                featuresToTables.getTableDefinitions().put(key, table);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid data");
        }
        return featuresToTables;
    }

    private static Map<String, String> simpleJsonMapToJavaMap(JSONObject featureAttributesJson) {
        if (featureAttributesJson == null) {
            return null;
        }
        HashMap<String, String> featureAttributesMap = new HashMap<String, String>();
        Set types = featureAttributesJson.keySet();
        for (String type : types) {
            featureAttributesMap.put(type, (String)featureAttributesJson.get((Object)type));
        }
        return featureAttributesMap;
    }

    private static JSONObject getJSONObject(Path featuresToTablesFile) throws Exception {
        JSONObject featuresToTableJson = (JSONObject)new JSONParser().parse((Reader)Files.newBufferedReader(featuresToTablesFile, StandardCharsets.UTF_8));
        if (featuresToTableJson == null || !featuresToTableJson.containsKey((Object)FEATURETOTABLE)) {
            return null;
        }
        return featuresToTableJson;
    }
}

