/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.shapeprocessing.data.shapes;

import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.pdok.shapeprocessing.data.shapes.FeatureToTableMapping;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FeatureToTableMappingLoader {
    private static final String FEATURETOTABLE = "featureToTableMapping";

    public static FeatureToTableMapping LoadFeatureToTableFromJSON(Path featuresToTablesPath) throws Exception {
        FeatureToTableMapping featuresToTables = new FeatureToTableMapping();
        JSONObject featuresToTableJson = FeatureToTableMappingLoader.getJSONObject(featuresToTablesPath);
        if (featuresToTableJson == null) {
            return featuresToTables;
        }
        try {
            JSONObject e = (JSONObject)featuresToTableJson.get((Object)FEATURETOTABLE);
            Set sources = e.keySet();
            for (String key : sources) {
                Object table = e.get((Object)key);
                String tableName = (String)table;
                featuresToTables.getFeatureToTables().put(key, tableName);
            }
            JSONObject attributes = (JSONObject)featuresToTableJson.get((Object)"attributes");
            Set attSources = attributes.keySet();
            for (String key : attSources) {
                String value = (String)attributes.get((Object)key);
                featuresToTables.getAttributes().put(key, value);
            }
            return featuresToTables;
        }
        catch (ClassCastException var9) {
            throw new Exception("Invalid data");
        }
    }

    private static Map<String, String> simpleJsonMapToJavaMap(JSONObject featureAttributesJson) {
        if (featureAttributesJson == null) {
            return null;
        }
        HashMap<String, String> featureAttributesMap = new HashMap<String, String>();
        Set types = featureAttributesJson.keySet();
        for (String type : types) {
            featureAttributesMap.put(type, (String)featureAttributesJson.get((Object)type));
        }
        return featureAttributesMap;
    }

    private static JSONObject getJSONObject(Path featuresToTablesFile) throws Exception {
        JSONObject featuresToTableJson = (JSONObject)new JSONParser().parse((Reader)Files.newBufferedReader(featuresToTablesFile, StandardCharsets.UTF_8));
        return featuresToTableJson != null && featuresToTableJson.containsKey((Object)FEATURETOTABLE) ? featuresToTableJson : null;
    }
}

