/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.shapeprocessing.data.shapes;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.pdok.shapeprocessing.data.shapes.FeatureToTable;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapesProcessor {
    public static void loadShapeToDB(File shapeFile, String host, int port, String database, String user, String password, String schema, FeatureToTable featureToTable, String encoding) throws Exception {
        HashMap<String, String> shapeLookup = new HashMap<String, String>();
        shapeLookup.put("url", shapeFile.toURI().toString());
        if (encoding != null && !encoding.equals("")) {
            shapeLookup.put("charset", encoding);
        }
        DataStore shapeStore = DataStoreFinder.getDataStore(shapeLookup);
        HashMap<String, Object> pgDbLookup = new HashMap<String, Object>();
        pgDbLookup.put("dbtype", "postgis");
        pgDbLookup.put("host", host);
        pgDbLookup.put("port", port);
        pgDbLookup.put("database", database);
        pgDbLookup.put("user", user);
        pgDbLookup.put("passwd", password);
        pgDbLookup.put("schema", schema);
        DataStore dbStore = DataStoreFinder.getDataStore(pgDbLookup);
        ShapesProcessor.loadShape(shapeStore, dbStore, featureToTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadShape(DataStore shapeStore, DataStore dataStore, FeatureToTable featureToTable) throws Exception {
        try {
            String typeName = shapeStore.getTypeNames()[0];
            SimpleFeatureSource featureSource = shapeStore.getFeatureSource(typeName);
            List<SimpleFeatureType> targetFeatureTypes = ShapesProcessor.getTargetFeatureTypes(featureSource, dataStore, typeName, featureToTable);
            for (SimpleFeatureType type : targetFeatureTypes) {
                ShapesProcessor.writeFeatures(featureSource, dataStore, type, featureToTable);
            }
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
            if (shapeStore != null) {
                shapeStore.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFeatures(SimpleFeatureSource featureSource, DataStore dataStore, SimpleFeatureType targetFeatureType, FeatureToTable featureToTable) throws Exception {
        SimpleFeatureCollection featureSourceCollection = featureSource.getFeatures();
        SimpleFeatureIterator featureSourceIterator = featureSourceCollection.features();
        DefaultTransaction transaction = new DefaultTransaction(targetFeatureType.getTypeName());
        FeatureWriter writer = dataStore.getFeatureWriterAppend(targetFeatureType.getTypeName(), (Transaction)transaction);
        int featureCount = 0;
        while (featureSourceIterator.hasNext()) {
            SimpleFeature sourceFeature = (SimpleFeature)featureSourceIterator.next();
            SimpleFeature targetFeature = (SimpleFeature)writer.next();
            ShapesProcessor.writeFeature(sourceFeature, targetFeature, targetFeatureType, featureToTable);
            writer.write();
            if (++featureCount % 10000 != 0) continue;
            transaction.commit();
        }
        try {
            transaction.commit();
        }
        finally {
            transaction.close();
        }
        writer.close();
        featureSourceIterator.close();
    }

    private static void writeFeature(SimpleFeature sourceFeature, SimpleFeature targetFeature, SimpleFeatureType targetFeatureType, FeatureToTable featuresToTablesFile) throws Exception {
        Map<String, String> targetTableAttributes = ShapesProcessor.getAttributes(targetFeatureType.getName().getLocalPart(), featuresToTablesFile);
        if (targetTableAttributes != null && targetTableAttributes.size() > 0) {
            Set<String> attributes = targetTableAttributes.keySet();
            HashSet<String> sourceProperties = new HashSet<String>();
            for (Property sourcePropertie : sourceFeature.getProperties()) {
                sourceProperties.add(sourcePropertie.getName().getLocalPart());
            }
            for (String attribute : attributes) {
                if (!sourceProperties.contains(attribute)) continue;
                targetFeature.setAttribute(targetTableAttributes.get(attribute), ShapesProcessor.createNullFromEmptyString(sourceFeature.getAttribute(attribute)));
            }
        } else {
            for (Property propertieName : sourceFeature.getProperties()) {
                targetFeature.setAttribute(propertieName.getName().getLocalPart().toLowerCase(), ShapesProcessor.createNullFromEmptyString(sourceFeature.getAttribute(propertieName.getName().getLocalPart())));
            }
        }
    }

    private static Object createNullFromEmptyString(Object valueToCheck) {
        if ("".equals(valueToCheck)) {
            return null;
        }
        return valueToCheck;
    }

    private static List<SimpleFeatureType> getTargetFeatureTypes(SimpleFeatureSource featureSource, DataStore dataStore, String sourceTypeName, FeatureToTable featureToTable) throws Exception {
        List<String> targetTables = ShapesProcessor.getTables(sourceTypeName, featureToTable);
        ArrayList<SimpleFeatureType> simpleFeatureTypes = new ArrayList<SimpleFeatureType>();
        for (String targetTable : targetTables) {
            SimpleFeatureType simpleFeatureType = null;
            List<String> typeNamesList = Arrays.asList(dataStore.getTypeNames());
            Map<String, String> targetTableAttributes = ShapesProcessor.getAttributes(targetTable, featureToTable);
            if (targetTableAttributes != null) {
                if (typeNamesList.contains(targetTable)) {
                    simpleFeatureType = dataStore.getSchema(targetTable);
                } else {
                    SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
                    featureBuilder.setName(targetTable);
                    featureBuilder.setNamespaceURI(((SimpleFeatureType)featureSource.getSchema()).getName().getNamespaceURI());
                    CoordinateReferenceSystem sourceCRS = ((SimpleFeatureType)featureSource.getSchema()).getCoordinateReferenceSystem();
                    featureBuilder.setCRS(sourceCRS);
                    List attributeSourceDescriptions = ((SimpleFeatureType)featureSource.getSchema()).getAttributeDescriptors();
                    Set<String> keys = targetTableAttributes.keySet();
                    for (AttributeDescriptor attributeSourceDescription : attributeSourceDescriptions) {
                        if (!keys.contains(attributeSourceDescription.getName().getLocalPart())) continue;
                        String atrributeName = targetTableAttributes.get(attributeSourceDescription.getName().getLocalPart());
                        AttributeTypeBuilder builder = new AttributeTypeBuilder();
                        builder.init(attributeSourceDescription);
                        builder.setName(atrributeName);
                        featureBuilder.add(builder.buildDescriptor(atrributeName));
                    }
                    simpleFeatureType = featureBuilder.buildFeatureType();
                }
            } else {
                simpleFeatureType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)featureSource.getSchema()), null, (CoordinateReferenceSystem)((SimpleFeatureType)featureSource.getSchema()).getCoordinateReferenceSystem(), (String)targetTable, null);
            }
            simpleFeatureTypes.add(simpleFeatureType);
            if (typeNamesList.contains(simpleFeatureType.getTypeName())) continue;
            dataStore.createSchema((FeatureType)simpleFeatureType);
        }
        return simpleFeatureTypes;
    }

    private static List<String> getTables(String sourceTypeName, FeatureToTable featureToTable) throws Exception {
        List<Object> tables = null;
        Set<String> patternStrings = featureToTable.getFeatureToTables().keySet();
        for (String patternString : patternStrings) {
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(sourceTypeName);
            if (!matcher.find()) continue;
            tables = featureToTable.getFeatureToTables().get(patternString);
        }
        if (tables == null) {
            tables = new ArrayList();
        }
        return tables;
    }

    private static Map<String, String> getAttributes(String targetTable, FeatureToTable featureToTable) throws Exception {
        if (featureToTable.getTableDefinitions().containsKey(targetTable)) {
            return featureToTable.getTableDefinitions().get(targetTable);
        }
        return null;
    }
}

