/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard;

import android.database.Cursor;
import android.database.CursorWrapper;
import java.util.Arrays;
import java.util.List;
import nl.qbusict.cupboard.convert.EntityConverter;

class PreferredColumnOrderCursorWrapper
extends CursorWrapper {
    private String[] mColumns;
    private final int[] mColumnMap;

    public PreferredColumnOrderCursorWrapper(Cursor cursor, String[] columns) {
        super(cursor);
        this.mColumns = columns;
        this.mColumnMap = new int[columns.length];
        Arrays.fill(this.mColumnMap, -1);
        this.mColumns = this.remapColumns(cursor.getColumnNames(), columns);
    }

    public PreferredColumnOrderCursorWrapper(Cursor cursor, List<EntityConverter.Column> columns) {
        this(cursor, PreferredColumnOrderCursorWrapper.toColumNames(columns));
    }

    private static String[] toColumNames(List<EntityConverter.Column> columns) {
        String[] cols = new String[columns.size()];
        for (int i = cols.length - 1; i >= 0; --i) {
            cols[i] = columns.get((int)i).name;
        }
        return cols;
    }

    private String[] remapColumns(String[] cursorColumns, String[] columns) {
        int last = 0;
        for (int i = 0; i < columns.length; ++i) {
            int index;
            this.mColumnMap[i] = index = super.getColumnIndex(columns[i]);
            if (index == -1) continue;
            last = i;
        }
        if (last + 1 < columns.length) {
            String[] newCols = new String[last + 1];
            System.arraycopy(columns, 0, newCols, 0, last + 1);
            columns = newCols;
        }
        return columns;
    }

    public String[] getColumnNames() {
        return this.mColumns;
    }

    public short getShort(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return 0;
        }
        return super.getShort(index);
    }

    public byte[] getBlob(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return null;
        }
        return super.getBlob(index);
    }

    public double getDouble(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return 0.0;
        }
        return super.getDouble(index);
    }

    public float getFloat(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return 0.0f;
        }
        return super.getFloat(index);
    }

    public int getInt(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return 0;
        }
        return super.getInt(index);
    }

    public long getLong(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return 0L;
        }
        return super.getLong(index);
    }

    public String getString(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return null;
        }
        return super.getString(index);
    }

    public boolean isNull(int columnIndex) {
        int index = this.mColumnMap[columnIndex];
        if (index == -1) {
            return true;
        }
        return super.isNull(index);
    }

    public int getColumnCount() {
        return this.mColumns.length;
    }

    public int getColumnIndex(String columnName) {
        throw new RuntimeException("Don't use getColumnIndex(), but use the indices supplied in the constructor.\nFor use in an EntityConverter, the columns and indices are always in the same order as returned from EntityConverter.getColumns()");
    }

    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        throw new RuntimeException("Don't use getColumnIndex(), but use the indices supplied in the constructor.\nFor use in an EntityConverter, the columns and indices are always in the same order as returned from EntityConverter.getColumns()");
    }
}

