/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.convert;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import nl.qbusict.cupboard.annotation.CompositeIndex;
import nl.qbusict.cupboard.annotation.Index;

public class IndexBuilder {
    private CompositeIndexBuilder mCompositeIndexBuilder = new CompositeIndexBuilder();
    private boolean mUnique = false;

    public CompositeIndexBuilder named(String name) {
        this.mCompositeIndexBuilder.named(name);
        if (this.mUnique) {
            this.mCompositeIndexBuilder.unique();
        }
        return this.mCompositeIndexBuilder;
    }

    public IndexBuilder unique() {
        this.mUnique = true;
        return this;
    }

    public Index build() {
        return new IndexImpl(this.mUnique, this.mCompositeIndexBuilder.mIndices, this.mCompositeIndexBuilder.mUniqueIndices);
    }

    private class CompositeIndexImpl
    implements CompositeIndex {
        private final String mName;
        private boolean mAscending;
        private int mOrder;

        public CompositeIndexImpl(String name) {
            this.mName = name;
        }

        void setAscending(boolean ascending) {
            this.mAscending = ascending;
        }

        void setOrder(int order) {
            this.mOrder = order;
        }

        @Override
        public boolean ascending() {
            return this.mAscending;
        }

        @Override
        public int order() {
            return this.mOrder;
        }

        @Override
        public String indexName() {
            return this.mName;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return CompositeIndex.class;
        }
    }

    private class IndexImpl
    implements Index {
        private final boolean mUnique;
        private final CompositeIndex[] mNames;
        private final CompositeIndex[] mUniqueNames;

        public IndexImpl(boolean unique, List<CompositeIndex> names, List<CompositeIndex> uniqueNames) {
            this.mUnique = unique;
            this.mNames = names.toArray(new CompositeIndex[names.size()]);
            this.mUniqueNames = uniqueNames.toArray(new CompositeIndex[uniqueNames.size()]);
        }

        @Override
        public CompositeIndex[] indexNames() {
            return this.mNames;
        }

        @Override
        public boolean unique() {
            return this.mUnique;
        }

        @Override
        public CompositeIndex[] uniqueNames() {
            return this.mUniqueNames;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Index.class;
        }
    }

    public class CompositeIndexBuilder {
        private List<CompositeIndex> mIndices = new ArrayList<CompositeIndex>(10);
        private List<CompositeIndex> mUniqueIndices = new ArrayList<CompositeIndex>(10);
        private CompositeIndexImpl mCurrentIndex;

        private CompositeIndexBuilder() {
        }

        public CompositeIndexBuilder named(String name) {
            this.mCurrentIndex = new CompositeIndexImpl(name);
            this.mIndices.add(this.mCurrentIndex);
            return this;
        }

        public CompositeIndexBuilder unique() {
            if (this.mIndices.remove(this.mCurrentIndex)) {
                this.mUniqueIndices.add(this.mCurrentIndex);
            }
            return this;
        }

        public CompositeIndexBuilder order(int order) {
            this.mCurrentIndex.setOrder(order);
            return this;
        }

        public CompositeIndexBuilder ascending() {
            this.mCurrentIndex.setAscending(true);
            return this;
        }

        public CompositeIndexBuilder descending() {
            this.mCurrentIndex.setAscending(false);
            return this;
        }

        public Index build() {
            return new IndexImpl(false, this.mIndices, this.mUniqueIndices);
        }
    }
}

