/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.internal.convert;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.convert.EntityConverter;
import nl.qbusict.cupboard.convert.FieldConverter;
import nl.qbusict.cupboard.convert.FieldConverterFactory;

public class DefaultFieldConverterFactory
implements FieldConverterFactory {
    private static HashMap<Type, FieldConverter<?>> sTypeConverters = new HashMap(25);

    @Override
    public FieldConverter<?> create(Cupboard cupboard, Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        return sTypeConverters.get(type);
    }

    static {
        sTypeConverters.put((Type)((Object)BigDecimal.class), new BigDecimalConverter());
        sTypeConverters.put((Type)((Object)BigInteger.class), new BigIntegerConverter());
        sTypeConverters.put((Type)((Object)String.class), new StringConverter());
        sTypeConverters.put(Integer.TYPE, new IntegerConverter());
        sTypeConverters.put((Type)((Object)Integer.class), new IntegerConverter());
        sTypeConverters.put(Float.TYPE, new FloatConverter());
        sTypeConverters.put((Type)((Object)Float.class), new FloatConverter());
        sTypeConverters.put(Short.TYPE, new ShortConverter());
        sTypeConverters.put((Type)((Object)Short.class), new ShortConverter());
        sTypeConverters.put(Double.TYPE, new DoubleConverter());
        sTypeConverters.put((Type)((Object)Double.class), new DoubleConverter());
        sTypeConverters.put(Long.TYPE, new LongConverter());
        sTypeConverters.put((Type)((Object)Long.class), new LongConverter());
        sTypeConverters.put(Byte.TYPE, new ByteConverter());
        sTypeConverters.put((Type)((Object)Byte.class), new ByteConverter());
        sTypeConverters.put((Type)((Object)byte[].class), new ByteArrayConverter());
        sTypeConverters.put(Boolean.TYPE, new BooleanConverter());
        sTypeConverters.put((Type)((Object)Boolean.class), new BooleanConverter());
        sTypeConverters.put((Type)((Object)Date.class), new DateConverter());
    }

    private static class DateConverter
    implements FieldConverter<Date> {
        private DateConverter() {
        }

        @Override
        public Date fromCursorValue(Cursor cursor, int columnIndex) {
            return new Date(cursor.getLong(columnIndex));
        }

        @Override
        public void toContentValue(Date value, String key, ContentValues values) {
            values.put(key, Long.valueOf(value.getTime()));
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }

    private static class BooleanConverter
    implements FieldConverter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean fromCursorValue(Cursor cursor, int columnIndex) {
            try {
                return cursor.getInt(columnIndex) == 1;
            }
            catch (NumberFormatException ex) {
                return "true".equals(cursor.getString(columnIndex));
            }
        }

        @Override
        public void toContentValue(Boolean value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }

    private static class ByteArrayConverter
    implements FieldConverter<byte[]> {
        private ByteArrayConverter() {
        }

        @Override
        public byte[] fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getBlob(columnIndex);
        }

        @Override
        public void toContentValue(byte[] value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.BLOB;
        }
    }

    private static class ByteConverter
    implements FieldConverter<Byte> {
        private ByteConverter() {
        }

        @Override
        public Byte fromCursorValue(Cursor cursor, int columnIndex) {
            return (byte)cursor.getInt(columnIndex);
        }

        @Override
        public void toContentValue(Byte value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }

    private static class LongConverter
    implements FieldConverter<Long> {
        private LongConverter() {
        }

        @Override
        public Long fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getLong(columnIndex);
        }

        @Override
        public void toContentValue(Long value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }

    private static class DoubleConverter
    implements FieldConverter<Double> {
        private DoubleConverter() {
        }

        @Override
        public Double fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getDouble(columnIndex);
        }

        @Override
        public void toContentValue(Double value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.REAL;
        }
    }

    private static class ShortConverter
    implements FieldConverter<Short> {
        private ShortConverter() {
        }

        @Override
        public Short fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getShort(columnIndex);
        }

        @Override
        public void toContentValue(Short value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.REAL;
        }
    }

    private static class FloatConverter
    implements FieldConverter<Float> {
        private FloatConverter() {
        }

        @Override
        public Float fromCursorValue(Cursor cursor, int columnIndex) {
            return Float.valueOf(cursor.getFloat(columnIndex));
        }

        @Override
        public void toContentValue(Float value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.REAL;
        }
    }

    private static class IntegerConverter
    implements FieldConverter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public Integer fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getInt(columnIndex);
        }

        @Override
        public void toContentValue(Integer value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }

    private static class StringConverter
    implements FieldConverter<String> {
        private StringConverter() {
        }

        @Override
        public String fromCursorValue(Cursor cursor, int columnIndex) {
            return cursor.getString(columnIndex);
        }

        @Override
        public void toContentValue(String value, String key, ContentValues values) {
            values.put(key, value);
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.TEXT;
        }
    }

    private static class BigIntegerConverter
    implements FieldConverter<BigInteger> {
        private BigIntegerConverter() {
        }

        @Override
        public BigInteger fromCursorValue(Cursor cursor, int columnIndex) {
            return new BigInteger(cursor.getString(columnIndex));
        }

        @Override
        public void toContentValue(BigInteger value, String key, ContentValues values) {
            values.put(key, value.toString());
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.TEXT;
        }
    }

    private static class BigDecimalConverter
    implements FieldConverter<BigDecimal> {
        private BigDecimalConverter() {
        }

        @Override
        public BigDecimal fromCursorValue(Cursor cursor, int columnIndex) {
            return new BigDecimal(cursor.getString(columnIndex));
        }

        @Override
        public void toContentValue(BigDecimal value, String key, ContentValues values) {
            values.put(key, value.toPlainString());
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.TEXT;
        }
    }
}

