/*
 * Decompiled with CFR 0.152.
 */
package nl.sijpesteijn.ilda;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.sijpesteijn.ilda.ColorData;
import nl.sijpesteijn.ilda.ColorHeader;
import nl.sijpesteijn.ilda.CoordinateData;
import nl.sijpesteijn.ilda.CoordinateHeader;
import nl.sijpesteijn.ilda.IldaColorTable;
import nl.sijpesteijn.ilda.IldaFormat;

public class IldaReader {
    public IldaFormat ildaFormat = new IldaFormat();
    private IldaColorTable colorTable = new IldaColorTable();
    private int max_height = 0;
    private int min_height = 0;
    private int max_width = 0;
    private int min_width = 0;
    private int max_depth = 0;
    private int min_depth = 0;

    public static void main(String[] args) throws Exception {
        IldaReader reader = new IldaReader();
        IldaFormat content = reader.read(new File("src/main/resources/examples/test.ild"));
        List<CoordinateHeader> coordinateHeaders = content.getCoordinateHeaders();
        for (CoordinateHeader coordinateHeader : coordinateHeaders) {
            int index = 0;
            List<CoordinateData> data = coordinateHeader.getCoordinateData();
            for (CoordinateData dat : data) {
                System.out.println("Frame nr: " + coordinateHeader.getFrameNumber() + ", point : " + index++ + ": x= " + dat.getX() + ", y= " + dat.getY() + ", z= " + dat.getZ() + ", color: " + dat.getColorData());
            }
        }
        if (content.getColorHeader() != null) {
            System.out.println(content.getColorHeader().toString());
        }
        assert (content.getCoordinateHeaders() != null);
        assert (content.getColorHeader().getTotalColors() == content.getColorData().size());
    }

    public IldaFormat read(File fileName) throws IOException, URISyntaxException {
        Path file = Paths.get(fileName.getAbsolutePath(), new String[0]);
        byte[] fileArray = Files.readAllBytes(file);
        int offset = 0;
        CoordinateHeader coordinateHeader = this.getCoordinateHeader(fileArray, offset);
        this.ildaFormat.addCoordinateHeader(coordinateHeader);
        while (coordinateHeader.getTotalPoints() > 0) {
            ArrayList<CoordinateData> coordinateDatas = new ArrayList<CoordinateData>();
            for (int i = 0; i < coordinateHeader.getTotalPoints(); ++i) {
                byte[] data = Arrays.copyOfRange(fileArray, offset + 32 + i * 8, offset + 32 + (i + 1) * 8);
                CoordinateData coordinateData = this.getCoordinateData(data);
                coordinateDatas.add(coordinateData);
            }
            coordinateHeader.setCoordinateDatas(coordinateDatas);
            coordinateHeader = this.getCoordinateHeader(fileArray, offset += 32 + 8 * coordinateHeader.getTotalPoints());
            this.ildaFormat.addCoordinateHeader(coordinateHeader);
        }
        this.ildaFormat.setMaxWidth(this.max_width);
        this.ildaFormat.setMinWidth(this.min_width);
        this.ildaFormat.setMaxHeight(this.max_height);
        this.ildaFormat.setMinHeight(this.min_height);
        this.ildaFormat.setMaxDepth(this.max_depth);
        this.ildaFormat.setMinDepth(this.min_depth);
        int start_color_header = offset + 32 + coordinateHeader.getTotalPoints() * 8;
        if (start_color_header < fileArray.length) {
            byte[] data = Arrays.copyOfRange(fileArray, start_color_header, start_color_header + 32);
            ColorHeader colorHeader = this.getColorHeader(data);
            this.ildaFormat.setColorHeader(colorHeader);
            int start_color_data = start_color_header + 32;
            ArrayList<ColorData> colorDatas = new ArrayList<ColorData>();
            for (int i = 0; i < colorHeader.getTotalColors(); ++i) {
                data = Arrays.copyOfRange(fileArray, start_color_data + i * 6, start_color_data + (i + 1) * 6);
                ColorData colorData = this.getColorData(data);
                colorDatas.add(colorData);
            }
            this.ildaFormat.setColorData(colorDatas);
        }
        return this.ildaFormat;
    }

    private ColorData getColorData(byte[] data) {
        ColorData colorData = new ColorData();
        int red1 = this.getSmallInteger(data[0]);
        int green1 = this.getSmallInteger(data[1]);
        int blue1 = this.getSmallInteger(data[2]);
        int red2 = this.getSmallInteger(data[3]);
        int green2 = this.getSmallInteger(data[4]);
        int blue2 = this.getSmallInteger(data[5]);
        colorData.setRed1(red1);
        colorData.setRed2(red2);
        colorData.setGreen1(green1);
        colorData.setGreen2(green2);
        colorData.setBlue1(blue1);
        colorData.setBlue2(blue2);
        return colorData;
    }

    private ColorHeader getColorHeader(byte[] data) {
        ColorHeader colorHeader = new ColorHeader();
        String protocol = this.getProtocol(data[0], data[1], data[2], data[3]);
        int formatCode = this.getSmallInteger(data[7]);
        String paletteName = this.getString(data, 8, 15);
        String companyName = this.getString(data, 16, 23);
        int totalColors = this.getInteger(data[24], data[25]);
        int paletteNumber = this.getInteger(data[26], data[27]);
        int scannerHead = this.getSmallInteger(data[30]);
        colorHeader.setProtocol(protocol);
        colorHeader.setFormatCode(formatCode);
        colorHeader.setPaletteName(paletteName);
        colorHeader.setCompanyName(companyName);
        colorHeader.setTotalColors(totalColors);
        colorHeader.setPaletteNumber(paletteNumber);
        colorHeader.setScannerHead(scannerHead);
        return colorHeader;
    }

    private CoordinateData getCoordinateData(byte[] data) {
        int x = this.getCoordinate(data[0], data[1]);
        int y = -1 * this.getCoordinate(data[2], data[3]);
        int z = this.getCoordinate(data[4], data[5]);
        boolean blanked = IldaReader.isBitSet(data[6], 6);
        if (!blanked) {
            this.setMaxMinValue(x, y, z);
        }
        boolean endImageData = IldaReader.isBitSet(data[6], 7);
        int colorCode = this.getSmallInteger(data[7]);
        CoordinateData coordinateData = new CoordinateData();
        coordinateData.setX(x);
        coordinateData.setY(y);
        coordinateData.setZ(z);
        coordinateData.setBlanked(blanked);
        coordinateData.setEndImageData(endImageData);
        ColorData color = this.colorTable.getColor(colorCode);
        assert (color != null);
        coordinateData.setColorData(color);
        return coordinateData;
    }

    private void setMaxMinValue(int x, int y, int z) {
        if (x > this.max_width) {
            this.max_width = x;
        }
        if (x < this.min_width) {
            this.min_width = x;
        }
        if (y > this.max_height) {
            this.max_height = y;
        }
        if (y < this.min_height) {
            this.min_height = y;
        }
        if (z > this.max_depth) {
            this.max_depth = z;
        }
        if (z < this.min_depth) {
            this.min_depth = z;
        }
    }

    private CoordinateHeader getCoordinateHeader(byte[] fileArray, int offset) {
        String protocol = this.getProtocol(fileArray[0 + offset], fileArray[1 + offset], fileArray[2 + offset], fileArray[3 + offset]);
        boolean threeD = this.get3D(fileArray[7 + offset]);
        String frameName = this.getString(fileArray, 8 + offset, 15 + offset);
        String companyName = this.getString(fileArray, 16 + offset, 23 + offset);
        int totalPoints = this.getInteger(fileArray[24 + offset], fileArray[25 + offset]);
        int frameNumber = this.getInteger(fileArray[26 + offset], fileArray[27 + offset]);
        int totalFrames = this.getInteger(fileArray[28 + offset], fileArray[29 + offset]);
        int scannerHead = this.getSmallInteger(fileArray[30 + offset]);
        CoordinateHeader coordinateHeader = new CoordinateHeader();
        coordinateHeader.setProtocol(protocol);
        coordinateHeader.setThreeD(threeD);
        coordinateHeader.setFrameName(frameName);
        coordinateHeader.setCompanyName(companyName);
        coordinateHeader.setTotalPoints(totalPoints);
        coordinateHeader.setFrameNumber(frameNumber);
        coordinateHeader.setTotalFrames(totalFrames);
        coordinateHeader.setScannerHead(scannerHead);
        return coordinateHeader;
    }

    private int getCoordinate(byte b, byte b1) {
        return (short)((b & 0xFF) << 8 | b1 & 0xFF);
    }

    private int getSmallInteger(byte b) {
        return b & 0xFF;
    }

    private static Boolean isBitSet(byte b, int bit) {
        return (b & 1 << bit) != 0;
    }

    private int getInteger(byte b, byte b1) {
        int high = b & 0xFF;
        int low = b1 & 0xFF;
        return high << 8 | low;
    }

    private String getString(byte[] fileArray, int start, int stop) {
        String name = "";
        for (int i = start; i <= stop; ++i) {
            name = name + (char)fileArray[i];
        }
        return name;
    }

    private boolean get3D(byte b) {
        return b == 0;
    }

    private String getProtocol(byte b, byte b1, byte b2, byte b3) {
        return "" + (char)b + (char)b1 + (char)b2 + (char)b3;
    }
}

