/*
 * Decompiled with CFR 0.152.
 */
package nl.sijpesteijn.ilda;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import nl.sijpesteijn.ilda.CoordinateData;
import nl.sijpesteijn.ilda.CoordinateHeader;
import nl.sijpesteijn.ilda.IldaFormat;
import nl.sijpesteijn.ilda.IldaReader;

public class IldaWriter {
    public static void main(String[] args) throws Exception {
        IldaWriter writer = new IldaWriter();
        IldaReader reader = new IldaReader();
        String fileName = "src/main/resources/examples/test.ild";
        IldaFormat ildaFormat = reader.read(new File("src/main/resources/examples/astroid.ild"));
        writer.write(ildaFormat, "src/main/resources/examples/test.ild");
    }

    public void write(IldaFormat ildaFormat, String fileName) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        int totalByteSize = this.getTotalByteSize(ildaFormat);
        byte[] bytes = new byte[totalByteSize];
        this.fillBytesWithCoordinate(bytes, ildaFormat.getCoordinateHeaders());
        Files.write(path, bytes, new OpenOption[0]);
    }

    private void fillBytesWithCoordinate(byte[] bytes, List<CoordinateHeader> coordinateHeaders) {
        int index = 0;
        for (CoordinateHeader coordinateHeader : coordinateHeaders) {
            bytes[index++] = (byte)coordinateHeader.getProtocol().charAt(0);
            bytes[index++] = (byte)coordinateHeader.getProtocol().charAt(1);
            bytes[index++] = (byte)coordinateHeader.getProtocol().charAt(2);
            bytes[index++] = (byte)coordinateHeader.getProtocol().charAt(3);
            bytes[index++] = 0;
            bytes[index++] = 0;
            bytes[index++] = 0;
            bytes[index++] = (byte)(!coordinateHeader.isThreeD() ? 1 : 0);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(0);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(1);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(2);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(3);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(4);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(5);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(6);
            bytes[index++] = (byte)coordinateHeader.getFrameName().charAt(7);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(0);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(1);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(2);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(3);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(4);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(5);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(6);
            bytes[index++] = (byte)coordinateHeader.getCompanyName().charAt(7);
            bytes[index++] = this.getHighByte(coordinateHeader.getTotalPoints());
            bytes[index++] = this.getLowByte(coordinateHeader.getTotalPoints());
            bytes[index++] = this.getHighByte(coordinateHeader.getFrameNumber());
            bytes[index++] = this.getLowByte(coordinateHeader.getFrameNumber());
            bytes[index++] = this.getHighByte(coordinateHeader.getTotalFrames());
            bytes[index++] = this.getLowByte(coordinateHeader.getTotalFrames());
            bytes[index++] = this.getHighByte(coordinateHeader.getScannerHead());
            bytes[index++] = 0;
            for (CoordinateData coordinateData : coordinateHeader.getCoordinateData()) {
                bytes[index++] = this.getHighByte(coordinateData.getX());
                bytes[index++] = this.getLowByte(coordinateData.getX());
                bytes[index++] = this.getHighByte(-1 * coordinateData.getY());
                bytes[index++] = this.getLowByte(-1 * coordinateData.getY());
                bytes[index++] = this.getHighByte(coordinateData.getZ());
                bytes[index++] = this.getLowByte(coordinateData.getZ());
                if (coordinateData.isBlanked() || coordinateData.isEndImageData()) {
                    if (coordinateData.isBlanked() && coordinateData.isEndImageData()) {
                        bytes[index++] = -64;
                    } else if (coordinateData.isBlanked()) {
                        bytes[index++] = 64;
                    } else if (coordinateData.isEndImageData()) {
                        // empty if block
                    }
                } else {
                    bytes[index++] = 0;
                }
                bytes[index++] = this.getLowByte(coordinateData.getColorData().getCode());
            }
        }
    }

    private byte getLowByte(int number) {
        return (byte)(number & 0xFF);
    }

    private byte getHighByte(int number) {
        return (byte)(number >> 8 & 0xFF);
    }

    private int getTotalByteSize(IldaFormat ildaFormat) {
        int size = 0;
        for (CoordinateHeader coordinateHeader : ildaFormat.getCoordinateHeaders()) {
            size += 32 + coordinateHeader.getTotalPoints() * 8;
        }
        return size;
    }
}

