/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.bondermj.pcoa;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.umcg.bondermj.pcoa.PcoaParamaters;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.RankingAlgorithm;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;
import umcg.genetica.math.matrix2.MatrixTools;
import umcg.genetica.math.stats.concurrent.ConcurrentBrayCurtis;
import umcg.genetica.math.stats.concurrent.ConcurrentCityBlock;
import umcg.genetica.math.stats.concurrent.ConcurrentCorrelation;
import umcg.genetica.math.stats.concurrent.ConcurrentCovariation;

public class DoPcoa {
    private static final RankingAlgorithm RANKER_TIE = new NaturalRanking(NaNStrategy.FAILED, TiesStrategy.SEQUENTIAL);
    private static final String HEADER = "  /---------------------------------------\\\n  |              Parallel PCA             |\n  |                                       |\n  |             Marc Jan Bonder           |\n  |            bondermj@gmail.com         |\n  |                                       |\n  |          Genetics department          |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/";
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final NumberFormat DEFAULT_NUMBER_FORMATTER = NumberFormat.getInstance();

    public static void main(String ... args) throws IOException, Exception {
        DenseDoubleMatrix2D matrix;
        ConcurrentCovariation c;
        DoubleMatrixDataset inputData;
        PcoaParamaters paramaters;
        System.out.println(HEADER);
        System.out.println();
        Date currentDataTime = new Date();
        System.out.println("Current date and time: " + DATE_TIME_FORMAT.format(currentDataTime));
        System.out.println();
        System.out.flush();
        Thread.sleep(25L);
        if (args.length == 0) {
            PcoaParamaters.printHelp();
            System.exit(1);
        }
        try {
            paramaters = new PcoaParamaters(args);
        }
        catch (ParseException ex) {
            System.err.println("Invalid command line arguments: ");
            System.err.println(ex.getMessage());
            System.err.println();
            PcoaParamaters.printHelp();
            System.exit(1);
            return;
        }
        PcoaParamaters.MatrixType matrixType = paramaters.getMatrixType();
        PcoaParamaters.PackageToUse packageToUse = paramaters.getPackageToUse();
        boolean overRows = paramaters.isOverRows();
        String nrComp = paramaters.getNumberComponentsToCalc();
        String fileIn = paramaters.getFileIn();
        File fileInput = new File(fileIn);
        if (!fileInput.exists()) {
            System.out.println("Warning: input for input file not found.");
            System.exit(-1);
        }
        String prefix = fileIn.replace(".txt", "");
        prefix = prefix.replace(".gz", "");
        int usable = paramaters.getThreads();
        if (usable > Runtime.getRuntime().availableProcessors()) {
            int nrProc = Runtime.getRuntime().availableProcessors();
            usable = (int)Math.floor((double)nrProc - (double)nrProc / 10.0);
        }
        ConcurrencyUtils.setNumberOfThreads((int)usable);
        boolean center = paramaters.isCenter();
        boolean scale = paramaters.isScale();
        try {
            inputData = DoubleMatrixDataset.loadDoubleData((String)fileIn);
        }
        catch (IOException ex) {
            Logger.getLogger(DoPcoa.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException("Problem reading data.");
        }
        catch (Exception ex) {
            Logger.getLogger(DoPcoa.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException("Problem reading data.");
        }
        if (overRows) {
            inputData = inputData.viewDice();
            System.out.println("\nConducting PCA over rows\n");
        } else {
            System.out.println("\nConducting PCA over columns\n");
        }
        if (center && scale) {
            MatrixTools.centerAndScaleColum((DoubleMatrix2D)inputData.getMatrix());
        } else if (scale) {
            MatrixTools.scaleColum((DoubleMatrix2D)inputData.getMatrix());
        } else if (center) {
            MatrixTools.centerColum((DoubleMatrix2D)inputData.getMatrix());
        }
        Integer nrComponents = DoPcoa.isInteger(nrComp) ? Integer.valueOf(Integer.parseInt(nrComp)) : (nrComp.equals("all") ? Integer.valueOf(inputData.columns()) : Integer.valueOf(inputData.columns()));
        if (nrComponents < 1) {
            System.out.println("Warning: Number of PCs to calculate should be at least 1");
            System.out.println("Reset nrComp to all");
            nrComponents = inputData.columns();
        } else if (nrComponents > inputData.columns()) {
            System.out.println("Warning: Number of PCs to calculate is larger dan dim of matrix");
            System.out.println("Reset nrComp to all");
            nrComponents = inputData.columns();
        }
        System.out.print("Calculating correlation matrix:");
        if (matrixType.equals((Object)PcoaParamaters.MatrixType.COVARIATION)) {
            c = new ConcurrentCovariation(usable);
            matrix = c.pairwiseCovariationDoubleMatrix(inputData.getMatrix().viewDice().toArray());
        } else if (matrixType.equals((Object)PcoaParamaters.MatrixType.CORRELATION)) {
            c = new ConcurrentCorrelation(usable);
            matrix = c.pairwiseCorrelationDoubleMatrix(inputData.getMatrix().viewDice().toArray());
        } else if (matrixType.equals((Object)PcoaParamaters.MatrixType.BRAYCURTIS)) {
            c = new ConcurrentBrayCurtis(usable);
            matrix = c.pairwiseBrayCurtisDoubleMatrix(inputData.getMatrix().viewDice().toArray());
        } else {
            c = new ConcurrentCityBlock(usable);
            matrix = c.pairwiseCityBlockDoubleMatrix(inputData.getMatrix().viewDice().toArray());
        }
        System.out.println("done");
        try {
            DoubleMatrixDataset t = new DoubleMatrixDataset((DoubleMatrix2D)matrix, inputData.getHashCols(), inputData.getHashCols());
            if (matrixType.equals((Object)PcoaParamaters.MatrixType.CORRELATION)) {
                t.save(prefix + ".CorrelationMatrix.txt.gz");
            } else if (matrixType.equals((Object)PcoaParamaters.MatrixType.COVARIATION)) {
                t.save(prefix + ".CovariationMatrix.txt.gz");
            } else if (matrixType.equals((Object)PcoaParamaters.MatrixType.BRAYCURTIS)) {
                t.save(prefix + ".BrayCurtisMatrix.txt.gz");
            } else {
                t.save(prefix + ".CityBlockMatrix.txt.gz");
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to write correlation matrix");
        }
        try {
            if (packageToUse.equals((Object)PcoaParamaters.PackageToUse.COLT)) {
                DoPcoa.calculateColtPCA((DoubleMatrixDataset<String, String>)inputData, (DoubleMatrix2D)matrix, prefix, nrComponents);
            } else {
                DoPcoa.calculateMtjPCA((DoubleMatrixDataset<String, String>)inputData, (DoubleMatrix2D)matrix, prefix, nrComponents);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DoPcoa.class.getName()).log(Level.SEVERE, null, ex);
        }
        matrix = null;
    }

    public static void calculateColtPCA(DoubleMatrixDataset<String, String> dataset, DoubleMatrix2D CorMatrix, String fileNamePrefix, Integer nrOfPCsToCalculate) throws IOException {
        String expressionFile = fileNamePrefix;
        System.out.println("- Performing PCA over matrix of size: " + CorMatrix.columns() + "x" + CorMatrix.rows());
        DenseDoubleEigenvalueDecomposition eig = new DenseDoubleEigenvalueDecomposition(CorMatrix);
        System.out.println("- Number of components to be written: " + nrOfPCsToCalculate);
        DoubleMatrix1D eigenValues = eig.getRealEigenvalues();
        TextFile out = new TextFile(expressionFile + ".PCAOverSamplesEigenvalues_pc.txt.gz", true);
        out.writeln("PCA\tEigenValue\tExplained variance\tTotal variance");
        double cumExpVarPCA = 0.0;
        double eigenValueSum = eigenValues.zSum();
        LinkedHashMap<String, Integer> tmpNameBuffer = new LinkedHashMap<String, Integer>();
        for (int pca = 0; pca < nrOfPCsToCalculate; ++pca) {
            double expVarPCA = eigenValues.getQuick((int)eigenValues.size() - 1 - pca) / eigenValueSum;
            int pcaNr = pca + 1;
            out.write(pcaNr + "\t" + eigenValues.getQuick((int)eigenValues.size() - 1 - pca) + "\t" + expVarPCA + "\t" + (cumExpVarPCA += expVarPCA) + "\n");
            tmpNameBuffer.put("Comp" + String.valueOf(pcaNr), pca);
        }
        out.close();
        DoubleMatrix2D eigenValueMatrix = eig.getV();
        DoubleMatrixDataset datasetEV = new DoubleMatrixDataset((DoubleMatrix2D)((DenseDoubleMatrix2D)eigenValueMatrix.viewColumnFlip().viewPart(0, 0, dataset.columns(), nrOfPCsToCalculate.intValue())), dataset.getHashCols(), tmpNameBuffer);
        eig = null;
        datasetEV.save(expressionFile + ".PCAOverSamplesEigenvectors_pc.txt.gz");
        System.out.println("Calculating PCs");
        System.out.println("Initializing PCA matrix");
        DoubleMatrixDataset datasetPCAOverSamplesPCAs = (long)dataset.columns() * (long)dataset.rows() < 0x7FFFFFFDL ? new DoubleMatrixDataset((DoubleMatrix2D)((DenseDoubleMatrix2D)dataset.getMatrix().zMult(datasetEV.getMatrix(), null)), dataset.getHashRows(), tmpNameBuffer) : new DoubleMatrixDataset((DoubleMatrix2D)((DenseLargeDoubleMatrix2D)dataset.getMatrix().zMult(datasetEV.getMatrix(), null)), dataset.getHashRows(), tmpNameBuffer);
        System.out.println("Saving PCA scores: " + expressionFile + ".PCAOverSamplesPrincipalComponents.txt.gz");
        datasetPCAOverSamplesPCAs.save(expressionFile + ".PCAOverSamplesPrincipalComponents.txt.gz");
    }

    public static void calculateMtjPCA(DoubleMatrixDataset<String, String> dataset, DoubleMatrix2D CorMatrix, String fileNamePrefix, Integer nrOfPCsToCalculate) throws IOException {
        String expressionFile = fileNamePrefix;
        System.out.println("- Performing PCA over matrix of size: " + CorMatrix.columns() + "x" + CorMatrix.rows());
        EVD evd = new EVD(CorMatrix.columns(), false, true);
        try {
            evd.factor(new DenseMatrix(CorMatrix.toArray()));
        }
        catch (NotConvergedException ex) {
            Logger.getLogger(DoPcoa.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("- Number of components to be written: " + nrOfPCsToCalculate);
        DenseDoubleMatrix1D eigenValues = new DenseDoubleMatrix1D(evd.getRealEigenvalues());
        TextFile out = new TextFile(expressionFile + ".PCAOverSamplesEigenvalues.txt.gz", true);
        out.writeln("PCA\tEigenValue\tExplained variance\tTotal variance");
        double cumExpVarPCA = 0.0;
        DenseMatrix eigenVectorsMatrix = evd.getRightEigenvectors();
        double[] eigenValuesRanked = RANKER_TIE.rank(eigenValues.toArray());
        DenseDoubleMatrix1D rankedeigenValues = new DenseDoubleMatrix1D((int)eigenValues.size());
        DenseMatrix rankedeigenVectorsMatrix = new DenseMatrix(eigenVectorsMatrix.numRows(), eigenVectorsMatrix.numColumns());
        for (int i = 0; i < eigenValuesRanked.length; ++i) {
            int correctColumn = eigenValuesRanked.length - (int)eigenValuesRanked[i];
            for (int r = 0; r < eigenVectorsMatrix.numRows(); ++r) {
                rankedeigenVectorsMatrix.set(r, correctColumn, eigenVectorsMatrix.get(r, i));
            }
            rankedeigenValues.setQuick(correctColumn, eigenValues.get(i));
        }
        eigenValues = rankedeigenValues;
        eigenVectorsMatrix = rankedeigenVectorsMatrix;
        double eigenValueSum = eigenValues.zSum();
        LinkedHashMap<String, Integer> tmpNameBuffer = new LinkedHashMap<String, Integer>();
        for (int pca = 0; pca < nrOfPCsToCalculate; ++pca) {
            double expVarPCA = eigenValues.getQuick(pca) / eigenValueSum;
            int pcaNr = pca + 1;
            out.write(pcaNr + "\t" + eigenValues.getQuick(pca) + "\t" + expVarPCA + "\t" + (cumExpVarPCA += expVarPCA) + "\n");
            tmpNameBuffer.put("Comp" + String.valueOf(pcaNr), pca);
        }
        out.close();
        DoubleMatrixDataset datasetEV = new DoubleMatrixDataset(MatrixTools.toDenseDoubleMatrix((DenseMatrix)eigenVectorsMatrix).viewPart(0, 0, dataset.columns(), nrOfPCsToCalculate.intValue()), dataset.getHashCols(), tmpNameBuffer);
        evd = null;
        datasetEV.save(expressionFile + ".PCAOverSamplesEigenvectors.txt.gz");
        datasetEV = null;
        System.out.println("Calculating PCs");
        System.out.println("Initializing PCA matrix");
        DenseMatrix scoreMatrix = new DenseMatrix(dataset.rows(), dataset.columns());
        new DenseMatrix(dataset.getMatrix().toArray()).mult(eigenVectorsMatrix.transpose(), (Matrix)scoreMatrix);
        DoubleMatrixDataset datasetPCAOverSamplesPCAs = new DoubleMatrixDataset(MatrixTools.toDenseDoubleMatrix((DenseMatrix)scoreMatrix).viewPart(0, 0, dataset.rows(), nrOfPCsToCalculate.intValue()), dataset.getHashRows(), tmpNameBuffer);
        System.out.println("Saving PCA scores: " + expressionFile + ".PCAOverSamplesPrincipalComponents.txt.gz");
        datasetPCAOverSamplesPCAs.save(expressionFile + ".PCAOverSamplesPrincipalComponents.txt.gz");
    }

    public static void regressOutPCs(DoubleMatrixDataset<String, String> dataset, String fileNamePrefix, String PcaFile, String eigenVectorFile, int nrPCAsOverSamplesToRemove, int nrIntermediatePCAsOverSamplesToRemoveToOutput) throws IOException {
        DenseDoubleAlgebra Alg = new DenseDoubleAlgebra();
        DoubleMatrixDataset datasetPCAOverSamplesPCAs = DoubleMatrixDataset.loadDoubleData((String)PcaFile);
        DoubleMatrix2D datasetPCAOverSamplesPCAsSmal = Alg.subMatrix(datasetPCAOverSamplesPCAs.getMatrix(), 0, datasetPCAOverSamplesPCAs.rows() - 1, 0, nrPCAsOverSamplesToRemove - 1);
        datasetPCAOverSamplesPCAs = null;
        System.gc();
        System.gc();
        DoubleMatrixDataset datasetEV = DoubleMatrixDataset.loadDoubleData((String)eigenVectorFile);
        DoubleMatrix2D datasetEVSmal = Alg.subMatrix(datasetEV.getMatrix(), 0, datasetEV.rows() - 1, 0, nrPCAsOverSamplesToRemove - 1);
        datasetEV = null;
        System.gc();
        System.gc();
        System.gc();
        System.out.println("\nInitializing residual gene expression matrix");
        for (int t = 0; t < nrPCAsOverSamplesToRemove; ++t) {
            dataset.getMatrix().assign(Alg.multOuter(datasetPCAOverSamplesPCAsSmal.viewColumn(t), datasetEVSmal.viewColumn(t), null), DoubleFunctions.minus);
            int nrPCAs = t + 1;
            if (nrPCAs % nrIntermediatePCAsOverSamplesToRemoveToOutput != 0) continue;
            dataset.save(fileNamePrefix + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
            System.out.println("Removed\t" + nrPCAs + "\tPCs. File:\t" + fileNamePrefix + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
        }
    }

    public static void generatePcCorrectedDataWithSkipping(String fileNamePrefix, String PcaFile, String eigenVectorFile, int startSize, int nrPCAsOverSamplesToRemove, int nrIntermediatePCAsOverSamplesToRemoveToOutput, ArrayList<String> compSkipList) throws IOException {
        DoubleMatrixDataset datasetPCAOverSamplesPCAs = DoubleMatrixDataset.loadDoubleData((String)PcaFile);
        DoubleMatrixDataset datasetEV = DoubleMatrixDataset.loadDoubleData((String)eigenVectorFile);
        DoubleMatrixDataset dataset = new DoubleMatrixDataset(null, datasetPCAOverSamplesPCAs.getHashRows(), datasetEV.getHashCols());
        String expressionFile = fileNamePrefix;
        System.out.println("\nInitializing residual gene expression matrix");
        DenseDoubleAlgebra Alg = new DenseDoubleAlgebra();
        DoubleMatrix2D datasetPCAOverSamplesPCAs_Mat = datasetPCAOverSamplesPCAs.getMatrix();
        DoubleMatrix2D datasetEV_Mat = datasetEV.getMatrix();
        datasetPCAOverSamplesPCAs = null;
        datasetEV = null;
        for (int r = 0; r < startSize - 1; ++r) {
            if (compSkipList.contains("Comp" + (r + 1))) continue;
            datasetEV_Mat.viewRow(r).assign(0.0);
        }
        boolean dataChanged = false;
        for (int r = startSize - 1; r < nrPCAsOverSamplesToRemove; ++r) {
            int nrPCAs = r + 1;
            if (!compSkipList.contains("Comp" + nrPCAs)) {
                datasetEV_Mat.viewRow(r).assign(0.0);
                dataChanged = true;
            }
            if (nrPCAs % nrIntermediatePCAsOverSamplesToRemoveToOutput != 0 || !dataChanged) continue;
            dataset.setMatrix(Alg.mult(datasetPCAOverSamplesPCAs_Mat, datasetEV_Mat));
            dataset.save(expressionFile + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
            System.out.println("Removed\t" + nrPCAs + "\tPCs. File:\t" + expressionFile + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
            dataChanged = false;
        }
    }

    public static void generatePcCorrectedData(String fileNamePrefix, String PcaFile, String eigenVectorFile, int startSize, int nrPCAsOverSamplesToRemove, int nrIntermediatePCAsOverSamplesToRemoveToOutput) throws IOException {
        DoubleMatrixDataset datasetPCAOverSamplesPCAs = DoubleMatrixDataset.loadDoubleData((String)PcaFile);
        DoubleMatrixDataset datasetEV = DoubleMatrixDataset.loadDoubleData((String)eigenVectorFile);
        DoubleMatrixDataset dataset = new DoubleMatrixDataset(null, datasetPCAOverSamplesPCAs.getHashRows(), datasetEV.getHashCols());
        String expressionFile = fileNamePrefix;
        System.out.println("\nInitializing residual gene expression matrix");
        DenseDoubleAlgebra Alg = new DenseDoubleAlgebra();
        DoubleMatrix2D datasetPCAOverSamplesPCAs_Mat = datasetPCAOverSamplesPCAs.getMatrix();
        DoubleMatrix2D datasetEV_Mat = datasetEV.getMatrix();
        datasetPCAOverSamplesPCAs = null;
        datasetEV = null;
        for (int r = startSize - 1; r < nrPCAsOverSamplesToRemove; ++r) {
            int nrPCAs = r + 1;
            if (nrPCAs % nrIntermediatePCAsOverSamplesToRemoveToOutput != 0) continue;
            dataset.setMatrix(Alg.mult(datasetPCAOverSamplesPCAs_Mat.viewPart(0, nrPCAs, datasetPCAOverSamplesPCAs_Mat.rows(), datasetPCAOverSamplesPCAs_Mat.columns() - nrPCAs), datasetEV_Mat.viewPart(nrPCAs, 0, datasetEV_Mat.rows() - nrPCAs, datasetEV_Mat.columns())));
            dataset.save(expressionFile + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
            System.out.println("Removed\t" + nrPCAs + "\tPCs. File:\t" + expressionFile + "." + nrPCAs + "PCAsOverSamplesRemoved.txt.gz");
        }
    }

    public static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

