/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.bondermj.pcoa;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class PcoaParamaters {
    private static final Logger LOGGER;
    private static final Options OPTIONS;
    private final String fileIn;
    private final String numberComponentsToCalc;
    private final boolean overRows;
    private final boolean center;
    private final boolean scale;
    private final MatrixType matrixType;
    private final PackageToUse packageToUse;
    private boolean multiThreading;
    private final int threads;
    private static final String DEFAULT_numberComponents = "all";
    private static final MatrixType DEFAULT_analysisType;
    private static final PackageToUse DEFAULT_package;
    private static final boolean DEFAULT_overRows = false;
    private static final int DEFAULT_nrThreads = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PcoaParamaters(String ... args) throws ParseException {
        String tmp;
        CommandLine commandLine;
        block13: {
            block15: {
                block16: {
                    this.multiThreading = false;
                    PosixParser parser = new PosixParser();
                    commandLine = parser.parse(OPTIONS, args, false);
                    this.fileIn = commandLine.hasOption('i') ? commandLine.getOptionValue('i') : null;
                    String string = this.numberComponentsToCalc = commandLine.hasOption("nc") ? commandLine.getOptionValue("nc") : DEFAULT_numberComponents;
                    if (!commandLine.hasOption('m')) break block15;
                    tmp = commandLine.getOptionValue('m');
                    if (!(tmp = tmp.toLowerCase()).equals("correlation")) break block16;
                    this.matrixType = MatrixType.CORRELATION;
                    break block13;
                }
                if (tmp.equals("covariation")) {
                    this.matrixType = MatrixType.COVARIATION;
                    break block13;
                } else if (tmp.equals("braycurtis") || tmp.equals("bray-curtis") || tmp.equals("bray curtis")) {
                    this.matrixType = MatrixType.BRAYCURTIS;
                    break block13;
                } else {
                    if (!(tmp.equals("cityblock") || tmp.equals("city-block") || tmp.equals("city block") || tmp.equals("mannhattan distance") || tmp.equals("mannhattan-distance") || tmp.equals("mannhattandistance") || tmp.equals("L1"))) {
                        this.matrixType = MatrixType.NULL;
                        throw new ParseException("In valid option for -m is given: " + tmp);
                    }
                    this.matrixType = MatrixType.CITYBLOCK;
                }
                break block13;
            }
            this.matrixType = DEFAULT_analysisType;
        }
        if (commandLine.hasOption('p')) {
            tmp = commandLine.getOptionValue('p');
            if ((tmp = tmp.toLowerCase()).equals("colt") || tmp.equals("parallel-colt") || tmp.equals("parallel colt")) {
                this.packageToUse = PackageToUse.COLT;
            } else {
                if (!tmp.equals("mtj")) {
                    this.packageToUse = PackageToUse.NULL;
                    throw new ParseException("In valid option for -p is given: " + tmp);
                }
                this.packageToUse = PackageToUse.MTJ;
            }
        } else {
            this.packageToUse = DEFAULT_package;
        }
        this.center = commandLine.hasOption('c');
        this.overRows = commandLine.hasOption('r');
        this.scale = commandLine.hasOption('s');
        try {
            int n = this.threads = commandLine.hasOption('t') ? Integer.parseInt(commandLine.getOptionValue('t')) : 1;
            if (this.threads > 1) {
                this.multiThreading = true;
                return;
            }
            this.multiThreading = false;
            return;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing --threads \"" + commandLine.getOptionValue('t') + "\" is not an int");
        }
    }

    public static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(" ", OPTIONS);
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }

    public static Options getOPTIONS() {
        return OPTIONS;
    }

    public String getNumberComponentsToCalc() {
        return this.numberComponentsToCalc;
    }

    public boolean isOverRows() {
        return this.overRows;
    }

    public boolean isCenter() {
        return this.center;
    }

    public boolean isScale() {
        return this.scale;
    }

    public boolean isMultiThreading() {
        return this.multiThreading;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getFileIn() {
        return this.fileIn;
    }

    public MatrixType getMatrixType() {
        return this.matrixType;
    }

    public PackageToUse getPackageToUse() {
        return this.packageToUse;
    }

    static {
        DEFAULT_analysisType = MatrixType.CORRELATION;
        DEFAULT_package = PackageToUse.COLT;
        LOGGER = Logger.getLogger(PcoaParamaters.class);
        OPTIONS = new Options();
        OptionBuilder.withArgName((String)"inputFile");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"The file to conduct the PCA on.");
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.isRequired();
        Option option = OptionBuilder.create((String)"i");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"String");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number components to calculate. Defaults to all");
        OptionBuilder.withLongOpt((String)"nrComponents");
        option = OptionBuilder.create((String)"nc");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"PCA over rows. Defaults to false. If false it will be conducted over colums (default).");
        OptionBuilder.withLongOpt((String)"overRows");
        option = OptionBuilder.create((String)"r");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Center input data. Defaults to false.");
        OptionBuilder.withLongOpt((String)"center");
        option = OptionBuilder.create((String)"c");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Scale input data. Defaults to false.");
        OptionBuilder.withLongOpt((String)"scale");
        option = OptionBuilder.create((String)"s");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"String");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Matrix type to perform PCA over, correlation, covariation, bray curtis or city block distances. Defaults to correlation");
        OptionBuilder.withLongOpt((String)"matrixType");
        option = OptionBuilder.create((String)"m");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"String");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Package to use the eigen value decomposition from");
        OptionBuilder.withLongOpt((String)"package");
        option = OptionBuilder.create((String)"p");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of threads to use. Defaults to: 1");
        OptionBuilder.withLongOpt((String)"threads");
        option = OptionBuilder.create((String)"t");
        OPTIONS.addOption(option);
    }

    public static enum PackageToUse {
        COLT,
        MTJ,
        NULL;

    }

    public static enum MatrixType {
        CORRELATION,
        COVARIATION,
        BRAYCURTIS,
        CITYBLOCK,
        NULL;

    }
}

