/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.concurrency.context;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import nl.talsmasoftware.concurrency.context.Context;
import nl.talsmasoftware.concurrency.context.ContextManager;
import nl.talsmasoftware.concurrency.context.ContextManagers;
import nl.talsmasoftware.concurrency.context.ContextSnapshot;

public class LegacyContextManagerBridge
implements nl.talsmasoftware.context.ContextManager<ContextSnapshot> {
    private static final Logger LOGGER = Logger.getLogger(ContextManagers.class.getName());

    public nl.talsmasoftware.context.Context<ContextSnapshot> initializeNewContext(ContextSnapshot value) {
        nl.talsmasoftware.context.Context reactivation = value != null ? value.reactivate() : null;
        return reactivation;
    }

    public nl.talsmasoftware.context.Context<ContextSnapshot> getActiveContext() {
        final ContextSnapshot legacySnapshot = LegacyContextManagerBridge.createLegacyContextSnapshot();
        return new nl.talsmasoftware.context.Context<ContextSnapshot>(){

            public ContextSnapshot getValue() {
                return legacySnapshot;
            }

            public void close() {
            }
        };
    }

    private static ContextSnapshot createLegacyContextSnapshot() {
        IdentityHashMap<ContextManager, Object> snapshot = new IdentityHashMap<ContextManager, Object>();
        boolean empty = true;
        for (ContextManager legacyManager : ServiceLoader.load(ContextManager.class, LegacyContextManagerBridge.class.getClassLoader())) {
            empty = false;
            nl.talsmasoftware.context.Context activeLegacyContext = legacyManager.getActiveContext();
            if (activeLegacyContext == null) continue;
            snapshot.put(legacyManager, activeLegacyContext.getValue());
        }
        if (empty) {
            LOGGER.finer("No legacy context managers found. It's probably safe to remove the legacy bridge from your application.");
        }
        return snapshot.isEmpty() ? LegacyContextSnapshot.EMPTY : new LegacyContextSnapshot(snapshot);
    }

    private static final class ReactivatedContext
    implements Context<Void> {
        private static Context<Void> EMPTY = new Context<Void>(){

            @Override
            public Void getValue() {
                return null;
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "ReactivatedLegacyContext{size=0}";
            }
        };
        private final List<Context<?>> reactivated;

        private ReactivatedContext(List<Context<?>> reactivated) {
            this.reactivated = reactivated;
        }

        @Override
        public Void getValue() {
            return null;
        }

        @Override
        public void close() {
            RuntimeException closeError = null;
            for (Context<?> reactivated : this.reactivated) {
                if (reactivated == null) continue;
                try {
                    reactivated.close();
                }
                catch (RuntimeException rte) {
                    if (closeError == null) {
                        closeError = rte;
                        continue;
                    }
                    closeError.addSuppressed(rte);
                }
            }
            if (closeError != null) {
                throw closeError;
            }
        }

        public String toString() {
            return "ReactivatedLegacyContext{size=" + this.reactivated.size() + '}';
        }
    }

    private static final class LegacyContextSnapshot
    implements ContextSnapshot {
        private static ContextSnapshot EMPTY = new ContextSnapshot(){

            @Override
            public Context<Void> reactivate() {
                return ReactivatedContext.EMPTY;
            }

            public String toString() {
                return "LegacyContextSnapshot{size=0}";
            }
        };
        private final Map<ContextManager, Object> snapshot;

        LegacyContextSnapshot(Map<ContextManager, Object> snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public Context<Void> reactivate() {
            ArrayList<nl.talsmasoftware.context.Context> reactivatedContexts = new ArrayList<nl.talsmasoftware.context.Context>(this.snapshot.size());
            try {
                for (Map.Entry<ContextManager, Object> entry : this.snapshot.entrySet()) {
                    reactivatedContexts.add(entry.getKey().initializeNewContext(entry.getValue()));
                }
                return new ReactivatedContext(reactivatedContexts);
            }
            catch (RuntimeException errorWhileReactivating) {
                for (Context context : reactivatedContexts) {
                    if (context == null) continue;
                    try {
                        context.close();
                    }
                    catch (RuntimeException rte) {
                        errorWhileReactivating.addSuppressed(rte);
                    }
                }
                throw errorWhileReactivating;
            }
        }

        public String toString() {
            return "LegacyContextSnapshot{size=" + this.snapshot.size() + '}';
        }
    }
}

