/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.lazy4j;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.talsmasoftware.lazy4j.LazyEvaluationException;

public final class Lazy<T>
implements Supplier<T> {
    private volatile Supplier<T> supplier;
    private volatile T result;
    private volatile RuntimeException exception;
    private int retryCount;

    private Lazy(int retryCount, Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "Lazy function is <null>.");
        this.retryCount = retryCount;
    }

    public static <T> Lazy<T> lazy(Supplier<T> supplier) {
        return Lazy.lazy(0, supplier);
    }

    public static <T> Lazy<T> lazy(int maxRetryCount, Supplier<T> supplier) {
        return new Lazy<T>(maxRetryCount, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceEagerEvaluation() {
        if (this.supplier != null) {
            Lazy lazy = this;
            synchronized (lazy) {
                block8: {
                    if (this.supplier != null) {
                        try {
                            this.result = this.supplier.get();
                            this.exception = null;
                            this.supplier = null;
                        }
                        catch (RuntimeException supplierException) {
                            this.result = null;
                            this.exception = supplierException;
                            if (this.retryCount <= 1) {
                                this.supplier = null;
                            }
                            if (this.retryCount == Integer.MAX_VALUE) break block8;
                            --this.retryCount;
                        }
                    }
                }
            }
        }
    }

    @Override
    public T get() {
        this.forceEagerEvaluation();
        if (this.exception != null) {
            throw new LazyEvaluationException("Could not evaluate lazy value: " + this.exception.getMessage(), this.exception);
        }
        return this.result;
    }

    public boolean isAvailable() {
        return this.supplier == null && this.exception == null;
    }

    public Optional<T> getIfAvailable() {
        return this.isAvailable() ? Optional.ofNullable(this.get()) : Optional.empty();
    }

    public void ifAvailable(Consumer<T> consumer) {
        Objects.requireNonNull(consumer, "Consumer of lazy value is <null>");
        if (this.isAvailable()) {
            consumer.accept(this.get());
        }
    }

    public <U> Lazy<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "Mapper function is <null>.");
        return Lazy.lazy(() -> mapper.apply((T)this.get()));
    }

    public <U> Lazy<U> flatMap(Function<? super T, ? extends Supplier<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "Mapper function is <null>.");
        return Lazy.lazy(() -> ((Supplier)Objects.requireNonNull(mapper.apply((T)this.get()), "Lazy supplier is <null>.")).get());
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.supplier != null ? "[not yet resolved]" : (this.exception != null ? "[threw exception]" : "[" + this.result + ']'));
    }
}

